<?php
/**
* DIƥʥ饹
*
* ܺ
* ƥʤεǽ륯饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class DIContainer 
{
	var $_components;
	var $_component_configs;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_components = array();
		$this->_component_configs = array();
	}

	/*
	 *    ͣΥ󥹥󥹼
	 */
	private static function &getInstance()
	{
		static $singleton_;
		if ( $singleton_ == null ){
			$singleton_ = new DIContainer();
		}
		return $singleton_;
	}

	/**
	 * DIƥʤ
	**/
	public static function createContainer( IProcedure $procedure )
	{
		log_info( "system",  "DIƥʤν򳫻Ϥޤ", __FILE__, __LINE__ );

		// 󥹥󥹤μ
		$container = & DIContainer::getInstance();

		// ==================================================
		// ݡͥեɤ߹
		// ==================================================

		// ƥॳݡͥեɤ߹
		$file = ResourceLocator::getSystemPath( 'config', 'component_defs.ini' );
		$sys_config = is_file($file) ? parse_ini_file($file,TRUE) : NULL;

		// ץꥱΥݡͥեɤ߹
		$file = ResourceLocator::getWebAppPath( 'config', 'component_defs.ini' );
		$app_config = is_file($file) ? parse_ini_file($file,TRUE) : NULL;

		// ޡ
		$config = $app_config ? $sys_config + $app_config : $sys_config;

		// ¸
		$container->component_config_files = $config;

		log_info( "system",  "DIƥʤνλޤ", __FILE__, __LINE__ );

	}

	/*
	 * DIƥʤ˴
	 */
	public static function destroy()
	{
		log_info( "system",  "DIƥʤ˴򳫻Ϥޤ", __FILE__, __LINE__ );

		// 󥹥󥹤μ
		$container = & DIContainer::getInstance();

		// ݡͥȤ˴
		$container->destroyComponents();

		log_info( "system",  "DIƥʤ˴λޤ", __FILE__, __LINE__ );
	}

	/*
	 * ݡͥȤ
	 */
	public function loadComponent( String $component_name )
	{
		log_info( "system",  "ݡͥ[$component_name]ɤޤ", __FILE__, __LINE__ );

		// ݡͥեɤ߹
		$config = ConfigLoader::loadConfig( $component_name, s('component') );

		// å¸
		$this->_component_configs[ "$component_name" ] = $config;

		// 饹̾
		$class_name = $config->getString( s('class_name') );

		// ݡͥȥפ
		$scope = $config->getString( s('scope') );

		// ݡͥȥפˤäˡѹ
		switch ( $scope ){
		case ComponentScope::TRANSIENT:
		case ComponentScope::REQUEST:
			{
				// ݡͥȤΥ󥹥
				$component = ClassUtil::newInstance( $class_name );
			}
			break;

		case ComponentScope::SESSION:
			{
				// ݡͥȤΥ󥹥󥹤򥻥å󤫤
				$component = unserialize( $_SESSION[ $component_name ] );

				// åˤʤС󥹥󥹤
				if ( $component == NULL ){
					$component = ClassUtil::newInstance( $class_name );
				}

			}
			break;
		}


		if ( !$component ){
			// scope˻ꤵ줿ɤ
			throw new ComponentConfigException( $component_name, "scope", "invalid scope value:$scope" );
		}

		// 󥹥󥹤IComponent󥿥եƤ뤫ǧ
		if ( !($component instanceof IComponent) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IComponent" );
		}

		log_info( "system",  "ݡͥ[$component_name]ޤ", __FILE__, __LINE__ );

		// ݡͥȤ
		$component->init( $config );

		// ݡͥȤϿ
		$this->_components[ "$component_name" ] = $component;

		log_info( "system",  "ݡͥ[$component_name]ɤޤ", __FILE__, __LINE__ );

		// ɤݡͥȤֵ
		return $component;
	}

	/*
	 * ϿѤߥݡͥȤ
	 */
	public static function getComponent( String $key )
	{
		// 󥹥󥹤μ
		$container = & DIContainer::getInstance();

		// ϿƤʤХɤߤ
		if ( !isset($container->_components[ "$key" ]) )
		{
			$component = $container->loadComponent( $key );

			if ( $component == NULL ){
				throw new ComponentNotRegisteredException( $key );
			}
		}
		else{
			// ݡͥȤμ
			$component = $container->_components[ "$key" ];
		}

		// ݡͥ
		$component_config = $container->_component_configs[ "$key" ];

		// ϿƤʤ㳰
		if ( $component_config == NULL ){
			throw new ComponentNotRegisteredException( $key );
		}

		// ݡͥȥפ
		$scope = $component_config->getString( s('scope') );

		// ϿƤʤ㳰
		if ( $scope == NULL ){
			throw new ComponentConfigException( $key, "scope", "mandatory" );
		}

		// ݡͥȤֵ
		switch ( $scope ){
		case ComponentScope::TRANSIENT:
			return clone $component;

		case ComponentScope::REQUEST:
			return $component;

		case ComponentScope::SESSION:
			return $component;
		}

		// scope˻ꤵ줿ɤ
		throw new ComponentConfigException( $key, "scope", "invalid key word:$scope" );

		return NULL;
	}

	/*
	 * ϿѤߥݡͥȤ˴sessionץݡͥȤϥåƤ¸
	 */
	public function destroyComponents()
	{
		log_info( "system",  "DIƥΥݡͥȤ˴ޤ", __FILE__, __LINE__ );

		
		// 󥹥󥹤μ
		$container = & DIContainer::getInstance();

		// ݡͥȤμ
		$components = $container->_components;

		// ٤ƤΥݡͥȤ˴
		foreach( $components as $component_name => $component ){

			// ݡͥ
			$component_config = $container->_component_configs[ $component_name ];

			// ݡͥȥפ
			$scope = $component_config->getString( s('scope') );

			// ݡͥȥפˤäƽʬ
			switch ( $scope ){
			case ComponentScope::TRANSIENT:
			case ComponentScope::REQUEST:
				// ʤˤ⤷ʤ
				break;

			case ComponentScope::SESSION:
				{
					// å˥󥹥󥹤򥻥å
					$_SESSION[ $component_name ] = serialize( $component );

					log_info( "system",  "ݡͥ[$component_name]ϥå¸ޤ", __FILE__, __LINE__ );
				}
				break;
			}

		}

		log_info( "system",  "DIƥΥݡͥȤ˴ޤ", __FILE__, __LINE__ );

	}

	/*
	 * 
	 */
	public function dump(){
		return $this->_components[ $key ];
	}
}

return __FILE__;