<?php
/**
* HTTPץ
*
* PHP version 5
*
* @package    procedures
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
class HttpProcedure extends Object implements IProcedure
{
	var $_events;
	var $_input_filters;
	var $_output_filters;
	var $_renderer;
	var $_task_manager;
	var $_page_selector;

	/*
	 * 󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();
	}

	/*
	 * ץ̾
	 */
	public function getProcedureName()
	{
		return "HTTP Procedure";
	}

	/*
	 * ץ
	 */
	public function init( Config $config )
	{
		$this->_events              = $config->getAssoc( s('events') );
		$this->_output_filters      = $config->getArray( s('output_filters') );
		$this->_input_filters       = $config->getArray( s('input_filters') );
		$this->_renderer            = $config->getString( s('renderer') );
		$this->_task_manager        = $config->getString( s('task_manager') );
		$this->_page_selector       = $config->getString( s('page_selector') );

		if ( !$this->_page_selector ){
			throw new ProcedureConfigException( 'page_selector', 'mandatory' );
		}
	}

	/*
	 * ץ¹Ԥ
	 */
	public function execute( IRequest $request, ProcedureContext $context, Response $response )
	{
		$proc_name = $context->getProcedureName();

		log_info( "system",  "ץ[$proc_name]¹Ԥޤ", __FILE__, __LINE__ );

		//=======================================
		// ޥ͡κ
		//

		// ޥ͡
		$task_manager_name = $this->_task_manager;
		$task_manager = Factory::createTaskManager( $task_manager_name );

		//=======================================
		// ϥե륿μ¹
		//

		if ( $this->_input_filters ) {
			log_info( "system",  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );

			foreach( $this->_input_filters as $filter_name ) {
				// ե륿
				$filter = Factory::createFilter( $filter_name );
				// ե륿μ¹
				$filter->filter( $request, $context, $response );
			}
	
			log_info( "system",  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );
		}

		//=======================================
		// ٥ȥǥѥå
		//

		$task_manager->dispatchEvents( $request, $this->_events );

		//=======================================
		// ٥Ƚ
		//

		$task_manager->processEvents( $context );

		//=======================================
		// ڡ
		//

		// ڡ쥯κ
		$page_selector_name = $this->_page_selector;
		$page_selector = Factory::createPageSelector( $page_selector_name );
		// ڡ
		$page = $page_selector->selectPage( $proc_name, $task_manager, $context, $response );

		//=======================================
		// ϥե륿μ¹
		//
		if ( $this->_output_filters ) {
			log_info( "system",  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );

			foreach( $this->_output_filters as $filter_name ) {
				// ե륿
				$filter = Factory::createFilter( s($filter_name) );
				// ե륿μ¹
				$filter->filter( $request, $context, $response );
			}

			log_info( "system",  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );
		}

		//=======================================
		// μ¹
		//
		if ( $this->_renderer && strlen($this->_renderer) > 0 ) {
			log_info( "system",  "¹Ԥޤ", __FILE__, __LINE__ );

			$renderer = Factory::createRenderer( $this->_renderer );
			if ( $renderer ) {
				$renderer->render( $page, $response );
			}
			log_info( "system",  "¹Ԥޤ", __FILE__, __LINE__ );

		}

		log_info( "system",  "ץ[$proc_name]¹Ԥޤ", __FILE__, __LINE__ );
	}
}

return __FILE__;