<?php

/**
* ǥեȤSQLӥ
*
* PHP version 5
*
* @package    sql_builders
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
abstract class DefaultSQLBuilder extends Object implements ISQLBuilder
{
	private $_type_mapping;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
	}

	/**
	 *  SQLӥ
	 */
	public function init( Config $config )
	{
		$this->_type_mapping = $config->getArray( s('type_mappings') );
	}

	/*
	 * SQLӥ̾
	 */
	public function getSQLBuilderName()
	{
		return "default SQL builder";
	}

	/*
	 * ץޥåԥ
	 */
	public function mapType( $type_name )
	{
		return isset($this->_type_mapping[$type_name]) ? $this->_type_mapping[$type_name] : $type_name;
	}

	/*
	 *	SQL(SELECT)
	 */
	public  function buildSelectSQL( ITableModel $model, SQLCriteria $criteria = NULL )
	{
		$table = $model->getTableName();

		$sql = "select * from $table";

		if ( !$criteria ){
			return $sql;
		}

		$where_clause = $criteria->getWhereClause();
		$order_by     = $criteria->getOrderBy();
		$limit        = $criteria->getLimit();
		$offset       = $criteria->getOffset();

		if ( $where_clause != NULL ){
			$sql .= " where $where_clause";
		}
		if ( $order_by != NULL ){
			$sql .= " order by $order_by";
		}
		if ( $limit != NULL ){
			$sql .= " limit $limit";
		}
		if ( $offset != NULL ){
			$sql .= " offset $offset";
		}
	
		return $sql;
	}

	/*
	 *	SQL(UPDATE)
	 */
	public  function buildUpdateSQL( ITableModel $model, DTO $dto )
	{
		try{
			$SQL_params      = array();
			$SQL_set         = array();
			$SQL_key_fields  = array();

			$field_list = $model->getFieldList();

			foreach( $field_list as $name ) 
			{
				$update = $model->getAnnotation( s($name), s('update') );

				if ( !$update ){
					// ̵ξ票顼
					throw new TableModelException( $model, $name, '[@update] annotation is required' );
				}

				// եɤΥå
				$pk = $model->getAnnotation( s($name), s('pk') );
				if ( $pk ){
					// եɤʤΤǹʤ
					$SQL_key_fields[ $name ] = $dto->get( s($name) );
					continue;
				}

				// @updateΥơͤˤäʬ
				switch ( $update->getValue() ){
				case 'value':
					// ͤǹ
					$SQL_set[] = "$name = ?";
					// ѥ᡼ɲ
					$SQL_params[] = $dto->get( s($name) );
					break;
				case 'function':
					// ؿ
					switch( $insert->getParameter() ){
					case 'now':		$function = 'NOW()';	break;
					default:        $function = 'NULL';		break;
					}
					// ؿǹ
					$SQL_set[] = "$name = $function";
					break;
				case 'no':
					// ʤ
					break;
				default:
					throw new TableModelException( $model, $name, '[@update] value is invalid' );
				}
			}

			// WHERE
			$SQL_where = array();
			foreach( $SQL_key_fields as $name => $value )
			{
				// ơȥȤɲ
				$SQL_where[] = "$name = ?";
				// ѥ᡼ɲ
				$SQL_params[] = $value;
			}

			$SQL_set    = implode( ',', $SQL_set );
			$SQL_where  = implode( ',', $SQL_where );

			$table = $model->getTableName();

			$sql = "update $table set $SQL_set where $SQL_where";

			return array( $sql, $SQL_params );
		}
		catch ( Exception $e )
		{
			throw new SQLBuilderException( "DefaultSQLBuilder#buildUpdateSQL failed" );
		}
	}

	/*
	 *	SQL(INSERT)
	 */
	public  function buildInsertSQL( ITableModel $model, DTO $dto )
	{
		try{
			$SQL_field_list   = NULL;
			$SQL_value_list   = NULL;
			$SQL_params       = array();

			$field_list = $model->getFieldList();

			foreach( $field_list as $name ) 
			{
				$insert = $model->getAnnotation( $name, s('insert') );

				if ( !$insert ){
					// ̵ξ票顼
					throw new TableModelException( $model, $name, '[@insert] annotation is required' );
				}

				// @insertΥơͤˤäʬ
				switch ( $insert->getValue() ){
				case 'value':
					// ͤǹ
					$SQL_field_list[] = $name;
					$SQL_value_list[] = '?';
					// ѥ᡼ɲ
					$SQL_params[] = $dto->get( $name );
					break;
				case 'function':
					// ؿ
					switch( $insert->getParameter() ){
					case 'now':		$function = 'NOW()';	break;
					default:        $function = 'NULL';		break;
					}
					// ؿǹ
					$SQL_field_list[] = $name;
					$SQL_value_list[] = $function;
					break;
				case 'no':
					// ʤ
					break;
				default:
					throw new TableModelException( $model, $name, '[@insert] value is invalid' );
				}
			}

			$SQL_field_list = implode( ',', $SQL_field_list );
			$SQL_value_list = implode( ',', $SQL_value_list );

			$table = $model->getTableName();

			$sql = "insert into $table($SQL_field_list) values($SQL_value_list)";

			return array( $sql, $SQL_params );
		}
		catch ( Exception $e )
		{
			throw new SQLBuilderException( "DefaultSQLBuilder#buildInsertSQL failed" );
		}
	}

	/*
	 *	SQL(count)
	 */
	public  function buildCountSQL( ITableModel $model, SQLCriteria $criteria = NULL )
	{
		$table_name = $model->getTableName();

		$sql = "select count(*) from $table_name";

		if ( $criteria && $criteria->getWhereClause() ){
			$where_clause = $criteria->getWhereClause();
			$sql .= " where $where_clause";
		}

		return $sql;
	}

	/*
	 *	SQL(max)
	 */
	public  function buildMaxSQL( ITableModel $model, $field_name, SQLCriteria $criteria = NULL )
	{
		$table_name = $model->getTableName();

		$sql = "select max($field_name) from $table_name";

		if ( $criteria && $criteria->getWhereClause() ){
			$where_clause = $criteria->getWhereClause();
			$sql .= " where $where_clause";
		}

		return $sql;
	}

	/*
	 *	SQL(DELETE)
	 */
	public  function buildDeleteSQL( ITableModel $model, SQLCriteria $criteria = NULL )
	{
		$table_name = $model->getTableName();

		$sql = "delete from $table_name";

		if ( !$criteria ){
			return $sql;
		}

		$where_clause = $criteria->getWhereClause();
		$limit        = $criteria->getLimit();
		$offset       = $criteria->getOffset();

		if ( $where_clause != NULL ){
			$sql .= " where $where_clause";
		}
		if ( $limit != NULL ){
			$sql .= " limit $limit";
		}
		if ( $offset != NULL ){
			$sql .= " offset $offset";
		}
	
		return $sql;
	}

}

return __FILE__;