<?php
/**
* ǥեȤΥơ֥ǥ
*
* PHP version 5
*
* @package    table_models
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
class DefaultTableModel extends Object implements ITableModel
{
	private $_model_id;
	private $_class_name;
	private $_class_vars;
	private $_annotations;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_model_id    = NULL;
		$this->_class_name  = get_class($this);
		$this->_class_vars  = get_class_vars($this->_class_name);

		$this->_annotation_list = array();
		foreach( $this->_class_vars as $key => $var ){
			$this->_annotations[$key] = AnnotationUtil::parse( $key, $var );
		}
	}

	/**
	 * ǥID
	 */
	public function setModelID( String $model_id )
	{
		$this->_model_id = $model_id;
	}

	/**
	 * ǥID
	 */
	public function getModelID()
	{
		return $this->_model_id;
	}

	/*
	 *	ơ֥̾
	 */
	public function getTableName()
	{
		if ( property_exists($this,'___table_name') ){
			$table_name = $this->___table_name;
		}
		else{
			$table_name = $this->_class_name;
		}
		return $table_name;
	}

	/*
	 *   ץ饤ޥꥭե̾
	 */
	public function getPrimaryKey()
	{
		$field_list = $this->getFieldList();

		foreach( $field_list as $field ){
			$annot_map = $this->getAnnotationMap( s($field) );
			if ( isset($annot_map['pk']) ){
				// @pkꤵƤ鳰
				return s($field);
			}
		}

		throw new TableModelException( $this, NULL, 'no primary key' );
	}

	/*
	 *   ե̾
	 */
	public function getForeignKey( String $model_name )
	{
		$field_list = $this->getFieldList();

		foreach( $field_list as $field ){
			$annot_map = $this->getAnnotationMap( s($field) );
			if ( isset($annot_map['fk']) ){
				// @fkꤵƤ鳰
				$fk = $annot_map[ 'fk' ];
				if ( $fk->getValue()->equals( $model_name ) ){
					return s($field);
				}
			}
		}

		throw new TableModelException( $this, NULL, "no foreign key for:$model_name" );
	}

	/*
	 *   Ÿեɤ
	 */
	public function getExtractField( String $model_name, String $field )
	{
		$extract_list = $this->getExtractFieldList();

		foreach( $extract_list as $extract ){
			// @source:model_name/field򸡺
			$annot = $this->getAnnotation( s($extract), s('source') );
			if ( $annot->getValue()->equals( s("$model_name/$field") ) ){
				return s($extract);
			}
		}

		return NULL;
	}

	/*
	 *   Ϣ
	 */
	public function getRelationList()
	{
		$result = array();

		$annotations = $this->_annotations;
		if ( $annotations ){
			foreach( $annotations as $field => $annot_list ){
				foreach( $annot_list as $annot ){
					// @relationꤵƤϢ
					if ( $annot && $annot->getName()->equals(s('relation')) && $annot->getValue()->equals(s('')) ){
						$result[] = $field;
					}
				}
			}
		}

		return $result;
	}

	/**
	 * եɤ¸ߤ뤫
	 */
	public function fieldExists( String $field_name )
	{
		return isset($this->_class_vars[$field_name]);
	}

	/*
	 *   °
	 */
	private function getAttributeList( String $name, String $value )
	{
		$result = array();

		$annotations = $this->_annotations;
		if ( $annotations ){
			foreach( $annotations as $attr => $annot_list ){
				foreach( $annot_list as $annot ){
					// °ξȽ
					if ( $annot->getName()->equals($name) && $annot->getValue()->equals($value) ){
						$result[] = $attr;
					}
				}
			}
		}

		return $result;
	}

	/*
	 *   եɰ
	 */
	public function getFieldList()
	{
		return $this->getAttributeList( s('field'), s('') );
	}

	/*
	 *   Ÿեɰ
	 */
	public function getExtractFieldList()
	{
		return $this->getAttributeList( s('extract'), s('') );
	}

	/*
	 *   Υơ
	 */
	public function getAnnotation( String $field, String $annotation_name )
	{
		$annot_map = $this->getAnnotationMap( $field );
		if ( is_null($annot_map) || !isset($annot_map["$annotation_name"]) ){
			return NULL;
		}
		return $annot_map["$annotation_name"];
	}

	/*
	 *   ꤷեɤΥΥơޥåפ
	 */
	public function getAnnotationMap( String $field )
	{
		if ( !isset($this->_annotations["$field"]) ){
			return NULL;
		}
		return $this->_annotations["$field"];
	}

	/*
	 *   Υơͤ
	 */
	public function getAnnotationValue( String $field, String $annotation_name, $defaultValue = NULL )
	{
		$annot = $this->getAnnotation( $field, $annotation_name );

		return $annot ? $annot->getValue() : $defaultValue;
	}

	/*
	 *   ʸ
	 */
	public function __toString()
	{
		return "[TableModel:" . get_class($this) . "]";
	}

}

return __FILE__;