<?php
/**
* PEAR:DBǡݡͥ
*
* PHP version 5
*
* @package    data_sources
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once( 'DB.php' );

class PearDbDataSource extends CharcoalComponent implements IDataSource
{
	var $_connected = false;
	var $_connection;

	var $_backend;
	var $_user;
	var $_password;
	var $_db_name;
	var $_server;
	var $_charset;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct( String $name = NULL )
	{
		parent::__construct(s($name));

		$this->_connected 	= false;
		$this->_connection 	= null;
	}

	/*
	 * ǡ̾
	 */
	public function getDataSourceName()
	{
		return "Pear:DB DataSource";
	}

	/*
	 * ݡͥȤ
	 */
	public function init( Config $config )
	{
		$this->_backend   = $config->getString( s('backend') );
		$this->_user      = $config->getString( s('user') );
		$this->_password  = $config->getString( s('password') );
		$this->_db_name   = $config->getString( s('db_name') );
		$this->_server    = $config->getString( s('server') );
		$this->_charset   = $config->getString( s('charset') );

	}

	/*
	 *    ³Ѥߤ
	 */
	public function isConnected()
	{
		return $this->_connected;
	}

	/*
	 *    Хåɤ
	 */
	public function getBackend()
	{
		return $this->_backend;
	}

	/*
	 *    ³襵Ф
	 */
	public function getServer()
	{
		return $this->_server;
	}

	/*
	 *    ³桼̾
	 */
	public function getUser()
	{
		return $this->_user;
	}

	/*
	 *    ³ѥɤ
	 */
	public function getPassword()
	{
		return $this->_password;
	}

	/*
	 *    ³ǡ١̾
	 */
	public function getDatabaseName()
	{
		return $this->_db_name;
	}

	/*
	 *    ³ʸɤ
	 */
	public function getCharacterSet()
	{
		return $this->_charset;
	}

	/*
	 *    ߥåȤȯ
	 */
	public function commit()
	{
		try {
		
			$this->_connection->commit();
			
		}
		catch ( PDOException $e ) 
		{
			_throw( new DBException( $e->getMessage() ) );
		}
	}

	/*
	 *    ǥեȤ³³
	 */
	public function connectDefault( $db_name_enabled = TRUE, $force = FALSE )
	{
		$db_name = $db_name_enabled ? $this->_db_name : NULL;
		$this->connect( $this->_backend, $this->_user, $this->_password, $this->_server, s($db_name), $force );
	}

	/*
	 *    ³
	 */
	public function connect( String $backend, String $user, String $password, String $server, String $db_name, $force = FALSE )
	{
		// ³Ѥߤʤ鲿⤷ʤ
		if ( $this->_connected && !$force ){
			return;
		}

		$DSN = array(
		    'phptype'  => "$backend",
		    'username' => "$user",
		    'password' => "$password",
		    'hostspec' => "$server",
		);
		if ( !$db_name->isEmpty() ){
			$DSN['database'] = "$db_name";
		}
		$DSN = v($DSN);

		$db_string = nl2br($DSN->toString());

		log_info( "sql", "DB³Ԥޤ³ʸ=[$db_string]", __FILE__, __LINE__ );

		$db = DB::connect( $DSN->toArray() );
		
		if ( DB::isError($db) ){
			$msg = DB::errorMessage($db) . " ³ʸ=[$db_string]";
			log_error( 'system', $msg, __FILE__, __LINE__ );
			_throw( new DBException( $msg ) );
		}
	
		log_info( "sql", "DB³ޤ", __FILE__, __LINE__ );

		$this->_connection = $db;
		$this->_connected = true;

		// ʸк
		$charset = $this->_charset;
		$db->query( "SET NAMES $charset" );
	}

	/*
	 *    ³Ĥ
	 */
	public function disconnect()
	{

		// ³Ƥʤʤ鲿⤷ʤ
		if ( !$this->_connected ){
			return;
		}

		// 
		$this->_connection->disconnect();

		$this->_connected = FALSE;
	}

	/*
	 *    ץڥɥơȥȤȯ
	 */
	private function _prepareExecute( String $sql, Vector $params = NULL )
	{
		if ( !$sql ){
			_throw( new NullPointerException() );
		}
//print "SQL:$sql start<BR>";
		$conv = EncodingConverter::fromString( 'DB_TO_LOG' );
		log_info( "sql", $sql, __FILE__, __LINE__ );
		if ( $params ){
			Logger::writeArray( "i:sql", $params, __FILE__, __LINE__ );
		}

//print "SQL:$sql<BR>";

		for( $i=0; $i<count($params); $i++ ){
			$p1 = $params[$i];
			if ( is_string($p1) ){
				$params[$i] = $p1;
			}
		}

		$stmt = $this->_connection->prepare($sql);
	
		if ( DB::isError($stmt) ){
			$msg = $stmt->getMessage();
			log_error( "system", $msg ,__FILE__,__LINE__ );
			_throw( new DBException( $msg ) );
		}

		$params = $params ? $params->toArray() : NULL;

		$result = $this->_connection->execute($stmt, $params);
		
		if ( DB::isError($result) ){
			$msg = $result->getMessage();
			log_error( "system", $msg ,__FILE__,__LINE__ );
			_throw( new DBException( $msg ) );
		}

		return $result;
	}

	/*
	 *    SQL򤽤Τޤȯ
	 */
	private function _query( String $sql )
	{
		log_info( "sql", $sql, __FILE__, __LINE__ );
	
		$result = $this->_connection->query($sql);
			
		if ( DB::isError($result) ){
			$msg = $result->getMessage();
			_throw( new DBException( $msg ) );
		}

		return $result;
	}

	/*
	 *    SQL򤽤Τޤȯԡʷ̥åȤ
	 */
	public function query( String $sql )
	{
		log_info( "sql", $sql, __FILE__, __LINE__ );

		// ³
		$this->connect( $this->_backend, $this->_user, $this->_password, $this->_server, $this->_db_name );

		// SQL¹ԤƷ̥åȤ
		$resultset = $this->_query( $sql );

		// ̥åȤֵ
		return $resultset;
	}

	/*
	 *    SQL򤽤Τޤȯԡʷ̥åȤʤ
	 */
	public function execute( String $sql )
	{
		log_info( "sql", $sql, __FILE__, __LINE__ );

		// ³
		$this->connect( $this->_backend, $this->_user, $this->_password, $this->_server, $this->_db_name );

		// SQL¹
		$this->_query( $sql );
	}

	/*
	 *    ץڥɥơȥȤȯ
	 */
	public function prepareExecute( String $sql, Vector $params = NULL )
	{
		$result = null;
		
		try {
			// ³
			$this->connect( $this->_backend, $this->_user, $this->_password, $this->_server, $this->_db_name );

			// statementμ¹
			$result = $this->_prepareExecute( $sql, $params );
		}
		catch ( Exception $e )
		{
			_catch( $e );

			$msg  = "PearDbDataSource#prepareExecute() failed:<BR>";
			$msg .= "[SQL]$sql<BR> [params]" . System::arrayToString($params) . "<BR>";

			_throw( new DBException( $msg ) );
		}

		return $result;
	}

	/*
	 *    ¹Է̷
	 */
	function numRows( $result )
	{
		return $result->numRows();
	}

	/*
	 *    եåϢֵѡ
	 */
	public function fetchAssoc( $result )
	{
		if ( $result === NULL ){
			_throw( new NullPointerException() );
		}
		if ( !is_object($result) ){
			_throw( new NonObjectException( $result ) );
		}
		return $result->fetchRow(DB_FETCHMODE_ASSOC);
	}

	/*
	 *    եåֵѡ
	 */
	public function fetchArray( $result )
	{
		if ( $result === NULL ){
			_throw( new NullPointerException() );
		}
		if ( !is_object($result) ){
			_throw( new NonObjectException( $result ) );
		}
		return $result->fetchRow(DB_FETCHMODE_ORDERED);
	}

	/*
	 *   Ǹ˼¹Ԥ줿AUTO_INCREMENTͤ
	 */
	public function getLastInsertId()
	{
		$sql  = 'select LAST_INSERT_ID()';

		$result = $this->prepareExecute( $sql, NULL, __FILE__, __LINE__ );

		if ( $row = $this->fetchArray($result) ){
			$val = $row[0];
			return $val;
		}

		return -1;
	}

}

return __FILE__;