<?php
/**
* ǥեȤΥեǥ
*
* PHP version 5
*
* @package    form_models
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
abstract class DefaultFormModel extends CharcoalComponent implements IFormModel
{
	private $_model_id;
	private $_class_name;
	private $_class_vars;
	private $_annotations;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_class_name = get_class($this);
		$this->_class_vars = get_class_vars($this->_class_name);

		$this->_annotation_list = array();
		foreach( $this->_class_vars as $key => $var ){
			if ( strpos($var,'@') !== FALSE ){
				$this->_annotations[$key] = AnnotationUtil::parse( $key, $var );
			}
		}
	}

	/**
	 * ǥID
	 */
	public function setModelID( $model_id )
	{
		$this->_model_id = $model_id;
	}

	/**
	 * ǥID
	 */
	public function getModelID()
	{
		return $this->_model_id;
	}

	/*
	 *	ե̾
	 */
	public function getFormName()
	{
		if ( property_exists($this,'___form_name') ){
			$table_name = $this->___form_name;
		}
		else{
			$table_name = $this->_class_name;
		}
		return $table_name;
	}

	/**
	 * եɤ¸ߤ뤫
	 */
	public function fieldExists( String $field_name )
	{
		return isset($this->_class_vars[ "$field_name" ]);
	}

	/*
	 *   ե̾
	 */
	public function getFieldList()
	{
		$result = array();

		$annotations = $this->_annotations;
		if ( $annotations ){
			foreach( $annotations as $field => $annot_list ){
				foreach( $annot_list as $annot ){
					// @fieldꤵƤե
					if ( $annot->getName()->equals( s('field') ) && $annot->getValue()->equals( s('') ) ){
						$result[] = $field;
					}
				}
			}
		}

		return $result;
	}

	/*
	 *   ϥȥ
	 */
	public function getInputList()
	{
		$result = array();

		$annotations = $this->_annotations;
		if ( $annotations ){
			foreach( $annotations as $field => $annot_list ){
				foreach( $annot_list as $annot ){
					// @inputꤵƤե
					if ( $annot->getName()->equals( s('input') ) && $annot->getValue()->equals( s('') ) ){
						$result[] = $field;
					}
				}
			}
		}

		return $result;
	}

	/*
	 *   Υơ
	 */
	public function getAnnotation( String $field, String $annotation_name )
	{
		$annot_map = $this->getAnnotationMap( $field );
		if ( is_null($annot_map) || !isset($annot_map["$annotation_name"]) ){
			return NULL;
		}
		$annot = $annot_map["$annotation_name"];
		return $annot;
	}

	/*
	 *   ꤷեɤΥΥơޥåפ
	 */
	public function getAnnotationMap( String $field )
	{
		if ( !isset($this->_annotations["$field"]) ){
			return NULL;
		}
		return $this->_annotations["$field"];
	}

	/*
	 *   Υơͤ
	 */
	public function getAnnotationValue( String $field, String $annotation_name, $defaultValue = NULL )
	{
		$annot = $this->getAnnotation( $field, $annotation_name );

		return $annot ? $annot->getValue() : $defaultValue;
	}


	/*
	 *   եॢΥơ
	 */
	public function getFormAnnotation( String $type )
	{
		$field = '___form';
		return $this->getAnnotation( $field, $type );
	}

	/*
	 *   եॢΥơͤ
	 */
	public function getFormAnnotationValue( String $type )
	{
		$field = s('___form');
		return $this->getAnnotationValue( $field, $type );
	}

	/*
	 *   ǥեȤΥץ󥯥饹
	 */
	public function getDefaultCaptionClass()
	{
		$key = "___default_caption_class";
		return isset($this->_class_vars[$key]) ? $this->_class_vars[$key] : NULL;
	}

	/*
	 *   ǥեȤΥץ󥹥
	 */
	public function getDefaultCaptionStyle()
	{
		$key = "___default_caption_style";
		return isset($this->_class_vars[$key]) ? $this->_class_vars[$key] : NULL;
	}

	/*
	 *   ǥեȤΥեɥ饹
	 */
	public function getDefaultFieldClass( String $field_type )
	{
		$key = "___default_{$field_type}_class";
		return isset($this->_class_vars[$key]) ? $this->_class_vars[$key] : NULL;
	}

	/*
	 *   ǥեȤΥեɥ
	 */
	public function getDefaultFieldStyle( String $field_type )
	{
		$key = "___default_{$field_type}_style";
		return isset($this->_class_vars[$key]) ? $this->_class_vars[$key] : NULL;
	}


	/*
	 *   ꥹȤθ
	 */
	public function getChoiceList( String $list_name )
	{
		return NULL;
	}


	/*
	 *   
	 */
	public function dump()
	{
		print "[annotation dump]<BR>";
		print "form name:" . $this->getFormName() . "<BR>";
		$annotations = $this->_annotations;
		if ( $annotations ){
			foreach( $annotations as $field => $annot_array ){
				print "field[$field]:<BR>";
				foreach( $annot_array as $name => $annot ){
					print str_repeat('&nbsp;',8);
					print '@' . $name . ' value=&gt;' . $annot->getValue() . ' param=&gt;' . $annot->getParameter() . '<BR>' ;
				}
			}
		}
	}

}

return __FILE__;