<?php
/**
* ե˽Ϥ饹
*
* PHP version 5
*
* @package    loggers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class FileLogger extends CharcoalComponent implements ILogger
{
	private $_open;
	private $_fp;
	private $_file_name;

	/*
	 * 󥹥ȥ饯
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_open = false;
		$this->_fp = null;
		$this->_file_name = null;
	}

	/*
	 * ǥȥ饯
	 */
	public function __destruct()
	{
		$this->close();
	}

	/*
	 * ̾
	 */
	public function getLoggerName(){
		return "File Logger";
	}

	/*
	 * 
	 */
	public function init( Config $config )
	{
		$file_name = $config->getString( s('file_name') );
		$file_name = ResourceLocator::getWebAppPath( s('logs'), $file_name );
		$this->_file_name = $file_name;
	}

	/*
	 * 򥷥åȥ
	 */
	public function terminate()
	{
	}

	/*
	 * ե̾
	 */
	public function getFileName(){
		return $this->_file_name;
	}

	/*
	 * ե뤬ץ󤵤Ƥ뤫
	 */
	public function isOpen()
	{
		return $this->_open;
	}

	/*
	 * ե򥪡ץ󤹤
	 */
	public function open()
	{
		// Ǥ˳Ƥʤʤˤ⤷ʤ
		if ( $this->_open ){
			return;
		}
		$this->_fp = fopen($this->_file_name, "a");
		$this->_open = true;
	}

	/*
	 * եĤ
	 */
	public function close()
	{
		if ( $this->_fp != null ){
			fclose ($this->_fp);
			$this->_fp = null;
		}
		$this->_open = false;
	}

	/*
	 * Խ
	 */
	public function writeln( $key, $level, $message, $file, $line )
	{
		$this->open();

		$time = date("y/m/d H:i:s");
		$file = basename($file);

		// 󥳡ǥѴ
		$conv = EncodingConverter::fromString( 'PHP_TO_LOG' );
		$message = $conv->convertEncoding( $message );

		// ³
		$this->open();

		// ե񤭹
		fwrite ($this->_fp, "$time [$level] $message                                 @$file($line) \n"); 
	}

}

return __FILE__;