<?php
/**
* ñʥޥ͡륯饹
*
* PHP version 5
*
* @package    task_managers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class DefaultTaskManager extends CharcoalComponent implements ITaskManager
{
	private $_tasks;
	private $_queue;
	private $_dependency_map;

	/*
	 * 󥹥ȥ饯
	 */
	public function __construct( Vector $dependency_map )
	{
		parent::__construct();

		$this->_tasks  = NULL;
		$this->_queue  = new EventQueue();
		$this->_dependency_map = $dependency_map;
	}

	/*
	 * 
	 */
	public function getTask( String $task_name )
	{
		if ( isset($this->_tasks["$task_name"]) ){
			return $this->_tasks["$task_name"];
		}

		// ʤк
		$task = Factory::createTask( $task_name );
		$this->_tasks["$task_name"] = $task;

		return $task;
	}

	/*
	 * ٥ȥǥѥåԤ
	 *
	 */
	public function dispatchEvents( IRequest $request, Vector $events )
	{
		log_info( "system",  "٥ȥǥѥå򳫻Ϥޤ", __FILE__, __LINE__ );

		$queue = $this->_queue;

		// 
		log_info( 'event', "starting to dispatch events.", __FILE__, __LINE__ );

		foreach( $events as $task_name => $event_name ){
			// μ
			$task = $this->getTask( s($task_name) );
			// ꥯȥ٥Ȥκ
			$event = Factory::createRequestEvent( s($event_name), $request );
			// ٥Ȥ򥤥٥ȥ塼ɲ
			$container_event = new TargetedEvent( s('targeted_event'), $task, $event );
			$queue->enqueue( $container_event );
			// 
			log_info( 'event', "targeted event wad dispatched: task=[$task] event=[$event] container=[$container_event]", __FILE__, __LINE__ );
		}

		log_info( "system",  "٥ȥǥѥåλޤ", __FILE__, __LINE__ );
	}

	/**
	 *   ٥ȽԤ
	 *
	 */
	public function processEvents()
	{
//		try{
			$queue = $this->_queue;

			// 祤٥Ƚ
			$max_event_loop = Profile::getInteger( 'TM_MAX_EVENT_LOOP', 100 )->getValue();

			// 祤٥Ƚ
			$max_event_time = Profile::getInteger( 'TM_MAX_EVENT_TIME', 10 )->getValue();

			$start = Benchmark::nowTime();

			$event_count = 0;
			while( !$queue->isEmpty() ){
				// 
				log_info( 'event', "loop count: $event_count", __FILE__, __LINE__ );
				log_info( 'event', "event queue: [ " . implode( ',', $queue->toArray() ) . " ]", __FILE__, __LINE__ );
				// ٥Ȥ
				$event = $queue->dequeue();
				// 
				log_info( 'event', "starting process an event[$event].", __FILE__, __LINE__ );
				// ٥Ȥ
				if ( $event instanceof TargetedEvent ){
					// 西ϸꤵƤ
					$target_task = $event->getTargetTask();
					// ٥Ȥ
					$target_event = $event->getEvent();
					// 
					log_info( 'event', "[$event] is targeted event: task=[$target_task] event=[$target_event]", __FILE__, __LINE__ );
					$process = TRUE;
					if ( $this->_dependency_map ){
						// ¸ޥåפƤ
						$target_task = $this->_getDependentTask( $target_task, $this->_dependency_map );
					}
					if ( $process ){
						// ٥Ƚ
						$result = $target_task->processEvent( $target_event );
						ExceptionStack::clear();
						// 
						log_info( 'event', "targeted event[$target_event] was processed by task[$target_task]: result=[$result]", __FILE__, __LINE__ );
						// ̤٥Ȥä饭塼˺ɲ
						if ( $result instanceof IEvent ){
							$queue->enqueue( $result );
							$event = NULL;
							log_info( 'event', "targeted event[$target_event] was consumed.", __FILE__, __LINE__ );
						}
						else {
							// ̤BooleanǤʤХ顼
							if ( !($result instanceof Boolean) ){
								_throw( new ProcessEventException( $target_event, $target_task, $result, s('ITask::processEvent() must return a [Boolean] value.') ) );
							}
							// ̤FALSEǤʤʤ饤٥Ⱦò
							if ( $result->isTrue() ){
								$event = NULL;
								log_info( 'event', "targeted event[$target_event] was consumed.", __FILE__, __LINE__ );
							}
						}
					}
				}
				else{
					// 
					log_info( 'event', "[$event] is dispatching to all tasks.", __FILE__, __LINE__ );

					// 西ϸꤵƤʤΤǡƤΥƤӽФ
					foreach( $this->_tasks as $task ){
						if ( $this->_dependency_map ){
							// ¸ޥåפƤ
							$task = $this->_getDependentTask( $target_task, $this->_dependency_map );
						}
						// ٥Ƚ
						$result = $task->processEvent( $event );
						// 
						log_info( 'event', "[$event] was processed by task[$task]: result=[$result]", __FILE__, __LINE__ );
						// ̤٥Ȥä饭塼˺ɲ
						if ( $result instanceof IEvent ){
							$queue->enqueue( $result );
							$event = NULL;
							log_info( 'event', "event[$event] was consumed.", __FILE__, __LINE__ );
						}
						else {
							// ̤BooleanǤʤХ顼
							if ( !($result instanceof Boolean) ){
								_throw( new ProcessEventException( $target_event, $target_task, $result, s('ITask::processEvent() must return a [Boolean] value.') ) );
							}
							// ̤FALSEǤʤʤ饤٥Ⱦò
							if ( $result->isTrue() ){
								$event = NULL;
								log_info( 'event', "event[$event] was consumed.", __FILE__, __LINE__ );
							}
						}
					}

				}
				// ٥Ȥʤä饭塼᤹
				if ( $event ){
					$queue->enqueue( $event );
					// 
					log_info( 'event', "[$event] was not processed.", __FILE__, __LINE__ );
				}
				// ٥ȥȤΥ󥯥
				$event_count ++;
				// ٥ȥȤĶƤ˥󥰤Фƽλ
				if ( $event_count > $max_event_loop ){
					log_warning( 'event', "٥Ƚ[$max_event_loop]Ķᡢ٥ȽǤޤ", __FILE__, __LINE__ );
					break;
				}
				// в֥å
				$now = Benchmark::nowTime();
				if ( $now - $start > $max_event_time ){
					log_warning( 'event', "٥ȼ¹Ի֤[$max_event_time]Ķᡢ٥ȽǤޤ", __FILE__, __LINE__ );
					break;
				}
			}
			// 
			$now = Benchmark::nowTime();
			$elapse = round( $now - $start, 4 );
			log_info( 'event', "event loop end. count=[$event_count] time=[$elapse]sec.", __FILE__, __LINE__ );
//		}
//		catch( Exception $ex ){
//			print "catch: $ex <BR>";
//		}
	}

	/**
	 *	¸Ƥ륿ʺƵؿ
	 */
	private function _getDependentTask( ITask $task, Vector $dependency_map )
	{
		$task_name = $task->getName();
		if ( isset($dependency_map[$task_name]) ){
			$dep_task = $dependency_map[$task_name];
			return $this->_getDependentTask( $dep_task, $dependency_task );
		}
		else{
			return $task;
		}
	}


}

return __FILE__;
