<?php
/**
* frontend interface of cache
*
* PHP version 5
*
* @package    core
* @author     CharcoalPHP Development Team
* @copyright  2008 - 2013 CharcoalPHP Development Team
*/

class Charcoal_Cache extends Charcoal_Object
{
	private static $drivers;

	/*
	 *	check if a logger is registered
	 */
	public static function isRegistered( Charcoal_String $key )
	{
		$key = $key->getValue();
		return isset(self::$drivers[$key]);
	}

	/*
	 *	register a logger
	 */
	public static function register( Charcoal_String $key, Charcoal_ICacheDriver $cache_driver )
	{
		$key = $key->getValue();

		// set a logger to array
		self::$drivers[$key] = $cache_driver;
	}

	/**
	 * Get non-typed data which is associated with a string key
	 */
	public static function get( Charcoal_String $key )
	{
		$driver_list = self::$drivers;

		if ( $driver_list && is_array($driver_list) ){
			foreach( $driver_list as $driver ){
				$ret = $driver->get( $key );
				if ( FALSE !== $ret ){
					return $ret;
				}
			}
		}

		return FALSE;
	}

	/**
	 * Save a value to cache
	 */
	public static function set( Charcoal_String $key, Charcoal_Object $value, Charcoal_Integer $duration = NULL )
	{
		$driver_list = self::$drivers;

		if ( $driver_list && is_array($driver_list) ){
			foreach( $driver_list as $driver ){
				if ( $duration )
					$driver->set( $key, $value, $duration );
				else
					$driver->set( $key, $value );
			}
		}
	}

	/**
	 * Delete a cache data
	 */
	public function delete( Charcoal_String $key )
	{
		$driver_list = self::$drivers;

		if ( $driver_list && is_array($driver_list) ){
			foreach( $driver_list as $driver ){
				$driver->delete( $key );
			}
		}
	}

}
return __FILE__;
