<?php
/**
* DBテーブル間の関連情報を保持するクラス
*
* PHP version 5
*
* @package    core
* @author     CharcoalPHP Development Team
* @copyright  2008 - 2013 CharcoalPHP Development Team
*/

class Charcoal_DBRelation
{
	public $target;
	public $foreign_key;
	public $key_field;
	public $linkage;
	public $extract;
	public $order_by;
	public $restrict;

	/*
	 *    コンストラクタ
	 *
	 *  @param ITableModel target 関連先テーブルモデル
	 *  @param string foreign_key 外部キーフィールド名
	 *  @param string key_field キーフィールド名
	 *  @param string linkage リンケージ指定
	 *  @param string extract 展開フィールド
	 *  @param string restrict 制限
	 */
	public function __construct( Charcoal_HashMap $relation_params )
	{
		$this->target       = $relation_params->get('target');
		$this->foreign_key  = $relation_params->get('foreign_key');
		$this->key_field    = $relation_params->get('key_field');
		$this->linkage      = $relation_params->get('linkage');
		$this->extract      = $relation_params->get('extract');
		$this->order_by     = $relation_params->get('order_by');
		$this->restrict     = $relation_params->get('restrict');
	}
}

return __FILE__;