<?php
/**
* Interface of cache driver
* 
* PHP version 5
*
* @package    interfaces
* @author     CharcoalPHP Development Team
* @copyright  2008 - 2013 CharcoalPHP Development Team
*/
interface Charcoal_ICacheDriver extends Charcoal_ICharcoalObject
{
	/**
	 * Get non-typed data which is associated with a string key
	 */
	public function get( Charcoal_String $key );

	/**
	 * Save a value to cache
	 */
	public function set( Charcoal_String $key, Charcoal_Object $value, Charcoal_Integer $duration = NULL );

	/**
	 * Delete a cache data
	 */
	public function delete( Charcoal_String $key );

}

return __FILE__;