/*
==============================================================================
	getid.c
==============================================================================
*/

#include "chadic.h"

int cha_get_nhinsi_str_id(hinsi)
    char **hinsi;
{
    int id, i, d;

    if (!*hinsi)
      cha_exit_file(1, "an empty string for hinsi");

    for (id = 0; *hinsi; hinsi++) {
	if (!**hinsi)
	  cha_exit_file(1, "an empty string for hinsi");
	for (i = 0; (d = Cha_hinsi[id].daughter[i]) != 0; i++) {
	    if (!strcmp(Cha_hinsi[d].name, *hinsi))
	      break;
	}
	if (!d){
	    cha_exit_file(1, "hinsi `%s' is undefined", *hinsi);
	    /* return 0; 970301 tatuo: ꤢ 0 ֤ */
	}
	id = d;
    }

    return id;
}

int cha_get_nhinsi_id(cell)
    chasen_cell_t *cell;
{
    char *hinsi_str[256];
    char **hinsi = hinsi_str;

    for (; !nullp(cell); cell = cha_cdr(cell))
      *hinsi++ = cha_s_atom(cha_car(cell));

    *hinsi = NULL;

    return cha_get_nhinsi_str_id(hinsi_str);
}

int cha_get_type_id(x)
    char *x;
{
    int i;

    if (x==NULL) {
	cha_exit_file(1, "null string for type");
	return 0;
    }

    if (x[0] == '*' && x[1] == '\0')
      return 0;

    for (i = 1; strcmp(Cha_type[i].name, x); ) {
	if (!Cha_type[++i].name) {
	    cha_exit_file(1, "type `%s' is undefined", x);
	    /* return 255; 970301 tatuo: ꤢ 255 ֤() */	
	}
    }

    return i;
}

int cha_get_form_id(x, type)
    char *x;
    int type;
{
    int i;

    if (x == NULL) {
	cha_exit_file(1, "null string for form");
	return 0;
    }

    if (x[0] == '*' && x[1] == '\0')
      return 0;

    if (type == 0) {
	cha_exit_file(1, "Invalid type number for type `%s'", x);
	return 0;
    }

    for (i = 1; strcmp(Cha_form[type][i].name, x); ) {
	if (!Cha_form[type][++i].name) {
	    cha_exit_file(1, "type `%s' has no katuyou `%s'", Cha_type[type].name, x);
	    return 0;
	}
    }

    return i;
}

