#ifndef __PAT_H__
#define __PAT_H__

#include "config.h"
#include <sys/types.h>

#define SIKII_BIT 16  /* ʸʸζڤϲӥå? (8 or 16) */

/* ǥåѤΥꥹȷ */
typedef struct pat_index_list {
  struct pat_index_list *next; /* Ĥ */
  long index; /* եΥǥå */
} pat_index_list;

/* ΡɤΥǡ¤ */
typedef struct pat_node {
  pat_index_list il; /* ǥåΥꥹ */
  short checkbit; /* åӥåȤλꡣ(ܤΥӥå?) */
  struct pat_node *right; /* ؤޤޡ */
  struct pat_node *left; /* ؤޤޡ */
} pat_node;

typedef struct __pat_h {
    pat_node *root;
    void *map;
    off_t size;
} pat_t;


/**************************
 * ؿΥץȥ *
 **************************/ 
pat_t *pat_open(char*, char*);
void pat_load(pat_t*, char*);
void pat_save(pat_t*, char*);
void pat_text_reopen(pat_t*, char*);

#define pat_text_size(pat) (pat->size)
#define pat_get_text(pat, pos) ((char *)(pat->map + pos))

/* pat.c */
/* ѥȥꥷڤǸ */
pat_node *pat_search(pat_t*, char*, char**);
pat_node *pat_search_exact(pat_t*, char*, char**);
/* ѥȥꥷڤ */
void pat_insert(pat_t *, char*, long, char *);
/* ѥȥꥷڥǡ */
void pat_show_patfile(pat_t*, FILE*, char*);

/* patfile.c */
pat_node *pat_malloc_node(); /* Matomete malloc */
pat_index_list *pat_malloc_index_list(); /* Matomete malloc */

/* morph.c */
void jisyohiki(char*); /*  */
void insert_dic_data(pat_t*, char*); /* ǡ*/

/************************************************************************
* 
* pat --- ѥȥꥷڤõ
* 
* : Ĥ(tatuo-y@is.aist-nara.ac.jp)
* 
* Ū: ѥȥꥷڤõԤ
* 
* ʸ: 
*   르ꥺΤʸ[1]򻲾ȤCǤμ
*   ʸ[2]Υץ򻲹ͤˤ
* [1] R. Sedgewick  ʿ顢ƣϡĸ 
*     르ꥺ (Algorithms) 2 2 õʸ󡦷׻
*     ʳؼ,1992. (B195-2,pp.68-72)
* [2] 졢ͭ߷ʿѡ§ ԽѰ
*     르ꥺ༭ŵ
*     Ωǳ,1994. (D74,pp.624-625)
* 
* :
*   1996/04/09  ư! (ǡκĹ8bit[2])
*           10  ϥ롼Ƶ˲ɡʸǡб(Ĺ̵)
*           30  /ɵǽΡɤΥǡ¤IDֹɲ()
*         5/06  ʬڤǡϽ
*         6/11  ChaSenμѤ˲¤
*           21  ϢƳ(INDEX򥭥å夹)
*         7/01  ʣμե(ѥ)鸡Ǥ褦ˤ
* 
* : ChaSenμѤ
* 
************************************************************************/
#endif /* __PAT_H__ */
