/*
 *  SUFARY --- Suffix Array ΤΥ饤֥
 *  sufary.h - SUFARY饤֥إåե
 *
 * $Id: sufary.h,v 1.13 2001/03/16 04:06:17 kazuma-t Exp $
 */

#ifndef __SUFARY_H__
#define __SUFARY_H__

#include "config.h"

#ifdef HAVE_WINSOCK2_H
#include <winsock2.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifndef KEYWORD_MAX_LENGTH
#define KEYWORD_MAX_LENGTH 5000
#endif

/* ޥɤ */
typedef enum eresult_{
    CONT,
    FAIL,
    EXIT,
    _ERROR
} eresult;

/* 顼 */
typedef enum eerror_ {
    _NOERROR,
    COMMAND,
    MEMORY,
    FILEIN,
    FILEOUT,
    STRUCTURE,
    UNKNOWN
} eerror;

/* SUFARY¤ */
typedef struct {
    eerror ee;      /* Х륨顼ɤݻ */
    long arraysize; /* Array 礭 */
    long left;  /* ϰϤκü(ϰϤ¦ؤ)   g_bottom */
    long right;     /* ϰϤαü(ϰϤ¦ؤ)   g_top */
    off_t txtsz;    /* ƥȥեΥ */
    off_t arysz;    /* 쥤եΥ */
    void *txtmap; /* ƥȥեΥޥåץɥ쥹 */
    void *arymap; /* 쥤եΥޥåץɥ쥹 */
} SUFARY;

/* ץȥ ѥ롼 */
/*** select.c ***/
char **sa_common_prefix_search(SUFARY*, char*, int, char**);

/*** chfile.c ***/
SUFARY *sa_openfiles(char*, char*);
void sa_closefiles(SUFARY*);

#endif /* __SUFARY_H__ */
