/*
    ChibiOS - Copyright (C) 2006..2018 Giovanni Di Sirio

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

#include "hal.h"

const uint8_t refAES_ECB_128[]={
0x65,0x86,0x9F,0x20,0x63,0x89,0x1C,0x2F,0x20,0x5D,
0x94,0x7F,0x55,0x67,0x58,0xFF,0xE9,0xFE,0x4F,0xD7,
0x93,0x03,0x43,0xDD,0xD0,0x7E,0xA3,0x37,0x58,0x83,
0x22,0xA2,0x2D,0x61,0xA0,0x41,0x57,0x31,0x65,0x0F,
0x7A,0x08,0x8F,0xD8,0x9C,0xA3,0xAB,0xC3,0x8E,0x6E,
0x16,0x11,0xED,0x0C,0xE4,0xA8,0x6C,0x86,0xBB,0x99,
0x3F,0x79,0x0A,0xAC,0x9F,0xD6,0xFC,0xCC,0xD9,0x71,
0x36,0x46,0x6F,0xFA,0xD7,0x61,0xCE,0x1F,0xF0,0x9C,
0xE8,0xE8,0x18,0x39,0x47,0x74,0x2C,0xCA,0x5A,0xDA,
0x5A,0x60,0xD3,0xD7,0x22,0xD5,0x3E,0x6A,0xD7,0x28,
0x59,0xF6,0x1C,0x3D,0x6E,0x02,0x06,0x28,0xE0,0x17,
0x7B,0x1F,0xC2,0xFD,0xE5,0x7C,0x11,0xE7,0x3D,0xC2,
0x82,0xC9,0xBB,0x62,0xA8,0xCB,0xF0,0x9A,0x9A,0x9E,
0x75,0x54,0x49,0xEE,0x97,0x66,0x66,0x00,0x79,0xEC,
0x9E,0xBF,0x91,0x47,0xCE,0x10,0xC3,0x78,0x2B,0x3C,
0xDA,0xFD,0x3D,0xBA,0xBE,0x51,0x60,0x46,0x6E,0xE3,
0x87,0x70,0x9D,0x9F,0x9E,0x4C,0x12,0xC3,0xA2,0x91,
0xEF,0xF5,0xAC,0xDE,0x8E,0x6C,0x5A,0x81,0xE3,0x42,
0x87,0x83,0xFC,0x22,0x32,0xED,0x85,0x39,0xB0,0x32,
0x49,0x77,0x49,0x9E,0xA1,0x8E,0x81,0x0B,0x2A,0x66,
0xD8,0x68,0x57,0x2D,0xDC,0x71,0x0C,0x41,0xBE,0x19,
0x2F,0x16,0x07,0x69,0x53,0xFF,0x63,0xE0,0xBB,0x2B,
0x98,0xD8,0xA5,0x58,0xB0,0xFA,0x98,0xBB,0xB4,0x98,
0x57,0x60,0xE1,0xD2,0x28,0x92,0x26,0xDD,0x81,0xC2,
0xEE,0xD9,0xD5,0x2F,0x54,0x75,0xAA,0x58,0x7D,0x9D,
0x7E,0x74,0x66,0xC1,0x43,0xD9,0x00,0x53,0xA4,0x8D,
0xFD,0xF0,0xEC,0x07,0xFB,0xAA,0x2C,0x9B,0x7B,0x09,
0x99,0x06,0x51,0xE2,0x68,0xAB,0xDF,0x8D,0x46,0x2D,
0x7D,0xCB,0x87,0x2A,0x3F,0x62,0x82,0x6D,0xAF,0xE6,
0xBB,0xAE,0x28,0x56,0x58,0x46,0x45,0xC4,0x51,0x61,
0x2E,0x52,0x21,0x20,0x7B,0xEF,0x8D,0x4A,0x7B,0xF9,
0x72,0xE7,0x3C,0x88,0x72,0x88,0xD4,0x87,0x90,0xE1,
0xD8,0xB0,0x33,0x6C,0x57,0xB7,0xD5,0x6E,0x2B,0x37,
0xCC,0x42,0xB0,0xAC,0xBB,0xED,0xB3,0x3D,0xD0,0xF5,
0xF4,0xF3,0x5E,0x17,0x66,0xE6,0x2D,0xF2,0x0D,0x89,
0x48,0xA1,0x10,0x3E,0xD2,0x92,0x0D,0x3C,0xAE,0x4E,
0x78,0xDD,0x6E,0x38,0x6E,0x8B,0x2A,0x80,0x5B,0x5A,
0x53,0x74,0x2B,0x55,0xD8,0x62,0xE9,0x00,0x98,0x60,
0x61,0x70,0x0E,0x2F,0x41,0x92,0xD5,0x5D,0xBD,0x94,
0x16,0x16,0x37,0x3C,0xE1,0x30,0x19,0xAF,0x4A,0xDD,
0x05,0xD7,0x67,0x96,0x24,0xE7,0x8E,0xBD,0x11,0x73,
0x85,0x42,0xD4,0x79,0xB2,0xA9,0xD3,0x4A,0x42,0x53,
0x76,0x1D,0x77,0xDB,0x35,0xE0,0x24,0xEA,0x8D,0xAA,
0x17,0x8F,0x4D,0xC7,0x34,0xF9,0xA5,0x8D,0x7A,0xF3,
0x94,0x67,0xC7,0xF0,0x2B,0x76,0x20,0xFA,0xAD,0xF2,
0x20,0x4C,0xAC,0xEC,0x74,0x6C,0xE1,0x06,0x2D,0x95,
0xAC,0xD5,0x16,0xEE,0x4E,0x32,0xF2,0x3E,0x5B,0x1C,
0x1B,0x2D,0xF6,0x6F,0x16,0x1E,0xAA,0x86,0x95,0xA4,
0x7B,0xA4,0xC1,0xDC,0xD6,0xF4,0x4F,0xDB,0xCB,0x9F,
0xC6,0x25,0x52,0xBA,0x64,0xCE,0x4E,0x18,0xB0,0xE3,
0x26,0xCE,0x56,0x0A,0x18,0x49,0x50,0x77,0xB1,0x54,
0xC9,0xA0,0x4E,0x96,0xBA,0x8E,0x0D,0xBC,0x60,0x27,
0x0F,0xD9,0x45,0x34,0x94,0x40,0x3C,0x11,0xB1,0x62,
0x40,0x7A,0xDF,0x94,0x6E,0x8A,0xD9,0x52,0xE1,0x01,
0x1D,0x05,0xF8,0xB0,0xE0,0x5D,0x8A,0xD7,0x4C,0x8D,
0x27,0x8E,0xDB,0xB3,0x55,0x68,0x35,0x8D,0xF0,0xD5,
0x2B,0x0B,0xEC,0x04,0x8E,0xAF,0x98,0x4A,0xD4,0xCA,
0x88,0xF9,0xB5,0x1D,0xF3,0x20,0xB2,0x71,0x80,0x3F,
0xDB,0x5D,0x0E,0x2A,0xA2,0xB2,0x75,0x21,0x33,0x74,
0x72,0x2E,0xA6,0x2F,0xC8,0xB0,0x68,0x99,0xB9,0xA6,
0x3E,0xA5,0x13,0xF7,0x3F,0xED,0xC5,0x0B,0xD1,0xCB,
0xAC,0x8B,0x83,0xFF,0x50,0x5E,0xBD,0x60,0x09,0x40,
0xA5,0xE0,0x99,0x1D,0xC8,0x9B,0x2F,0x6F,0x1A,0x5A,
0x9D,0x90,0x62,0xBB,0x61,0xBD,0x6E,0x3B,0xD9,0x13,

};
const uint8_t refAES_ECB_192[]={
0x28,0xEA,0xD0,0xAB,0xC6,0x9F,0x53,0xAF,0xF1,0xB3,
0xC4,0x7C,0xAD,0x1F,0x12,0x35,0x05,0x23,0x89,0x52,
0x06,0xA3,0x4C,0x0A,0xCC,0x3E,0x0D,0xE3,0xCD,0x93,
0xC7,0x2D,0xFD,0x79,0x4B,0x5F,0xAC,0x7E,0xD5,0x9F,
0xE7,0x6D,0x74,0x35,0x43,0xD7,0xB0,0x28,0x69,0x3E,
0xF6,0xA0,0xCE,0xA8,0x66,0xBA,0x5A,0xDE,0x86,0xCE,
0x72,0x88,0x85,0xA8,0x01,0xB4,0x9E,0xC3,0xCA,0xCA,
0xEA,0xD8,0x60,0x8E,0x0A,0x46,0x63,0x8E,0x59,0xFA,
0xAE,0xE0,0xC7,0xCC,0x8C,0xB3,0x63,0x26,0xB5,0xFC,
0xF5,0xF9,0x06,0x93,0x91,0xF4,0x4E,0x25,0xB6,0x0E,
0xA4,0x82,0xC2,0xED,0x86,0xBB,0xB5,0x96,0x85,0x6B,
0xFA,0xA9,0xF0,0xFF,0x85,0x16,0xA9,0x48,0x83,0x9E,
0x4F,0x8E,0x74,0x6B,0x57,0x3D,0x67,0x3E,0xDE,0xC8,
0x4F,0x45,0xD0,0xBA,0x58,0x81,0x4C,0xAA,0x59,0x76,
0xA8,0xC7,0xF1,0x9B,0x9A,0x7A,0x4C,0xBE,0xC2,0x82,
0x63,0xFB,0xDA,0x57,0x4D,0x6A,0x79,0x94,0x3C,0x00,
0xE2,0xA9,0xE0,0x2D,0x9F,0x73,0x9F,0xFE,0x09,0x3B,
0x08,0xFC,0xFE,0x1E,0x4F,0x5F,0xD6,0x11,0x6C,0xAD,
0xF8,0x78,0x3E,0x2C,0xB6,0x80,0xD9,0x6D,0x91,0xC1,
0x92,0xAB,0xA2,0x63,0xBF,0x0F,0x19,0xC0,0xBF,0x9B,
0xF0,0x73,0xB2,0x19,0x3C,0xF1,0x06,0x1A,0x26,0x3C,
0x36,0xC0,0x2D,0x86,0x08,0x3A,0x5F,0xD7,0x81,0xD3,
0xCD,0xA1,0xF6,0x33,0xD4,0x65,0xD2,0xDC,0x18,0x80,
0x89,0xAC,0x4C,0xAA,0x7C,0x0D,0x16,0xCF,0xE9,0xDA,
0x4D,0xCF,0x20,0x6D,0x1D,0x6A,0x71,0x62,0xB8,0x74,
0x08,0x5D,0x77,0xBE,0x25,0x5F,0x91,0x51,0xA7,0x99,
0xB6,0xE9,0x3C,0x53,0xCD,0x21,0x61,0xE0,0x8B,0xC6,
0xCF,0xB6,0x33,0xEB,0xF4,0x45,0xBC,0x18,0x04,0x02,
0x00,0xC8,0x86,0xE7,0x30,0x3C,0xC6,0xBA,0x4D,0xE0,
0x5A,0x3D,0xB5,0xD8,0x9A,0x97,0xF4,0xA7,0x4F,0x07,
0x4A,0x2C,0x00,0x01,0xEB,0x58,0x91,0x8D,0x71,0xB3,
0x68,0xEC,0xEA,0xD0,0x59,0xBE,0x4F,0x99,0xD7,0x36,
0x2E,0x60,0xE4,0x9F,0x14,0x71,0x74,0x94,0x00,0x34,
0xCC,0xD0,0x3F,0x4D,0xDC,0xC7,0xCD,0xF5,0x95,0x94,
0xA2,0x6B,0x71,0x7F,0x3E,0xB5,0xC9,0x70,0x0D,0x33,
0x98,0x8D,0x7B,0x62,0x21,0xB5,0xA3,0xC3,0xD5,0xF6,
0x90,0x50,0x6B,0x55,0xB7,0x8B,0x78,0x4B,0x1C,0x27,
0xE3,0x37,0x96,0x82,0x7B,0xCE,0xF9,0x2B,0xF2,0xC2,
0x6E,0x89,0xE8,0x21,0x24,0xCB,0x58,0x53,0xAD,0x99,
0xCA,0x21,0x0A,0x80,0xE8,0xDD,0x28,0xE4,0x08,0x50,
0x06,0xCF,0xFF,0x59,0x28,0x7F,0xE6,0x53,0x4C,0x74,
0xA1,0xE0,0x92,0xA2,0x58,0x83,0x05,0xEA,0xBD,0x8B,
0x90,0xEC,0xBE,0x6F,0xFF,0xAF,0x74,0x60,0x0D,0x18,
0xBF,0xB5,0x68,0x18,0xDA,0xD5,0x20,0x85,0xDC,0xCB,
0xD0,0xC4,0x42,0x16,0xFE,0xE8,0x37,0x38,0x26,0xE4,
0x28,0xD5,0x64,0x2C,0xDC,0x88,0x2D,0x0D,0x20,0x7E,
0x82,0x48,0xB8,0x6B,0xD1,0x69,0xC5,0x2A,0xAB,0x3F,
0xBA,0x3E,0xEC,0xDF,0xCC,0xB9,0x89,0x84,0x80,0x9E,
0xC7,0xF6,0x36,0x06,0xD8,0xEA,0x8A,0x65,0x7E,0xFB,
0x91,0xD5,0x13,0x90,0xB1,0x21,0x70,0x15,0x39,0xDF,
0x1C,0x9C,0xEB,0x98,0x3D,0x01,0xA8,0x7B,0x28,0x7C,
0x6A,0x9E,0x40,0xB7,0xFA,0xE2,0xBE,0xEC,0x0D,0x9F,
0x53,0x10,0xAB,0x60,0x10,0x6F,0xC1,0x54,0x7A,0xAC,
0x0A,0x6A,0x91,0xE5,0xB6,0x6E,0x2D,0xF2,0x99,0x2B,
0xB5,0xA1,0xE3,0x2D,0x89,0x28,0x6E,0xC3,0xE7,0x0C,
0x28,0x6C,0xEF,0x42,0x8F,0xBC,0xAC,0xFA,0xA5,0x7C,
0xEB,0x4B,0x14,0xD9,0xF6,0x0F,0x9C,0x1E,0x21,0xB4,
0x82,0x9A,0x3E,0x98,0x0C,0xE2,0xCC,0xCB,0xE9,0xF0,
0xF4,0x45,0x0D,0xDD,0x50,0x16,0x91,0xDB,0xBD,0xA7,
0xE3,0x81,0x47,0x33,0x63,0x30,0xB5,0x4B,0xD8,0xB1,
0xF6,0x54,0xE0,0xB5,0x43,0x06,0xAB,0x34,0x1E,0x12,
0xCC,0x68,0xFF,0xAF,0x59,0xDF,0x65,0xB1,0x7F,0x59,
0x5D,0x74,0xAE,0x93,0xB3,0x79,0xE6,0xA0,0xD6,0xE6,
0x67,0x7E,0x6D,0x44,0x87,0x8B,0xB1,0x12,0xA1,0x0F,

};
const uint8_t refAES_ECB_256[]={
0xC5,0x1C,0x71,0x03,0xC3,0x2E,0x0A,0xF7,0xB7,0xF9,
0xEC,0xF2,0x47,0xA8,0xE5,0xE2,0xA0,0x43,0x78,0xF4,
0xB7,0x56,0xD8,0x14,0x13,0x60,0x30,0xFC,0xB2,0xF0,
0x22,0x4C,0xB6,0x5B,0x7E,0xB2,0x20,0x28,0x4E,0x46,
0x26,0x8D,0xD9,0x86,0x38,0x0C,0x71,0x8F,0x4E,0xAD,
0xC9,0xC9,0x70,0x74,0x5B,0xA9,0x10,0xBC,0xA8,0xBC,
0x09,0xEF,0xBA,0x65,0x2A,0xAC,0xFB,0x60,0xD1,0xA1,
0x65,0x0D,0x91,0xD0,0x43,0x73,0xD8,0xF9,0x73,0x6E,
0x2E,0x0F,0x7D,0x93,0xB2,0x34,0x74,0x31,0x27,0x02,
0x6B,0x61,0xE7,0x8F,0xD8,0x6B,0x13,0xC9,0xC8,0x9D,
0xF7,0x88,0xBC,0x88,0x79,0x51,0x5E,0x92,0x43,0x83,
0xE6,0x3C,0x55,0x8E,0xB2,0x70,0x42,0x36,0x78,0xBF,
0x61,0x6D,0xB7,0x96,0xFC,0xEA,0x55,0xEB,0x66,0x0F,
0xFB,0xAC,0x24,0xB7,0x14,0x2D,0x56,0x6D,0xE6,0x88,
0x1F,0x9F,0xF7,0xAF,0x7D,0x57,0x0A,0x00,0x54,0x0E,
0x5B,0xA8,0x0D,0xC3,0x9E,0xFC,0x21,0x8E,0x6E,0xDD,
0x19,0xA3,0xAA,0xBC,0x92,0xAB,0x10,0xA5,0x0E,0x9D,
0xC7,0x31,0x66,0xDE,0xA9,0xDC,0x35,0xEF,0x34,0x23,
0x03,0x3C,0xBB,0x44,0xD4,0x14,0x0D,0xD3,0x0C,0xCE,
0x4F,0x91,0xAE,0x46,0x13,0x0D,0x55,0xF2,0x2E,0xBC,
0xDD,0xAC,0x83,0xB2,0x8A,0x19,0xE1,0x3E,0xC0,0x8E,
0x9F,0x50,0x92,0x8A,0x6C,0xE6,0x4A,0x79,0xBB,0x80,
0xCA,0x2D,0x01,0x48,0x30,0x95,0xE2,0xFA,0x2B,0x2B,
0x67,0x60,0x2B,0x13,0x03,0xF5,0x1E,0x74,0x76,0xA9,
0x9C,0x04,0x56,0x2B,0xEF,0xFC,0xFD,0xEC,0xD5,0x8A,
0xE1,0x3D,0x3D,0x70,0x2A,0x08,0x77,0x0B,0x3D,0xD2,
0x33,0x1D,0xE7,0xF8,0x8C,0x41,0xB0,0x62,0x6D,0x01,
0xC0,0xD3,0xA8,0x4E,0x8C,0xAA,0xA0,0xDC,0x91,0xAC,
0x33,0xE2,0x55,0x6C,0xC4,0xE2,0x4E,0xCF,0xE4,0x53,
0xCA,0xA6,0x18,0x8B,0xA6,0x3A,0xAE,0x7A,0xAE,0x73,
0xA5,0x98,0x9A,0x85,0xD6,0x89,0xA6,0x34,0x1C,0x9A,
0x69,0xE2,0x89,0x64,0x9D,0xEE,0x13,0xE3,0x9D,0x59,
0x91,0xFE,0x3C,0x97,0xE6,0xE9,0x1A,0xF4,0x2E,0xAC,
0xE1,0x3D,0xC7,0xC4,0x68,0xED,0xF4,0xDB,0x6D,0xFC,
0xD0,0xB1,0x4D,0x76,0xA4,0x13,0x68,0x9E,0x0E,0x51,
0x8A,0x71,0x61,0xF9,0x8C,0x39,0xEF,0x0E,0x1F,0x19,
0xA4,0x20,0xBC,0xCC,0x19,0xAF,0x80,0x6F,0x88,0x93,
0x2A,0xF7,0x50,0x37,0xF1,0x83,0x90,0xEE,0xC6,0x63,
0x31,0x1A,0x1B,0xD2,0x53,0x85,0x77,0x22,0x44,0xB7,
0x75,0x55,0x57,0xBB,0xA7,0xF4,0xC9,0x8B,0x0E,0xC8,
0xCB,0xB9,0x62,0x87,0xCF,0x1E,0x60,0x5E,0x53,0x64,
0x29,0xC9,0x7D,0xA1,0x4A,0x9E,0xDD,0x38,0xD9,0xB6,
0xE3,0xF7,0x9B,0xC6,0xF7,0x4C,0xDB,0xE9,0x92,0x08,
0x3E,0xE2,0x45,0xB9,0xF3,0x14,0x44,0xD7,0x78,0xA0,
0x78,0x56,0x2A,0xC8,0x83,0x64,0xAF,0xF1,0xD0,0x53,
0x0B,0xFA,0x2C,0xDA,0x0B,0xE5,0xE0,0xD2,0x70,0xA2,
0x5A,0x12,0x48,0xF1,0xD7,0xF3,0x00,0x4E,0xBD,0x16,
0xB3,0x1F,0x9A,0x2C,0x2A,0xF2,0xF7,0xAB,0x84,0x2C,
0x96,0x00,0x8F,0x0D,0x9A,0x5F,0xFA,0x56,0x5D,0x7A,
0x0B,0xBC,0xC1,0xFE,0x14,0x2F,0xF4,0x9A,0xEB,0xAF,
0x78,0x29,0x34,0x16,0x93,0xE7,0x57,0xCA,0x05,0xF2,
0x46,0x77,0x03,0x90,0x46,0xF0,0x65,0x05,0x9E,0xCF,
0xD0,0xCE,0xC5,0xE0,0x43,0xE0,0x9F,0x8B,0xA0,0x9F,
0x44,0x0B,0x5F,0xD5,0x19,0x1E,0x5A,0xCF,0x26,0xD4,
0x2D,0x67,0xC2,0x8F,0x6F,0xE5,0x29,0xDA,0xF1,0x26,
0x5B,0x87,0xA0,0x4C,0xA1,0xB6,0x27,0x7A,0x70,0x07,
0xBE,0x8E,0xCD,0x8F,0x4E,0x0E,0xBE,0xCB,0xF3,0x43,
0x79,0xB8,0xFB,0x06,0x41,0x96,0xA0,0xE9,0xDC,0x78,
0x23,0x26,0x79,0x71,0x26,0x4E,0x08,0x03,0x16,0x25,
0xEE,0xF6,0xF9,0x61,0xDF,0x73,0x13,0xA5,0xF6,0x04,
0x5E,0x17,0x52,0x6D,0x17,0x3A,0x4A,0x88,0x95,0x7D,
0x8F,0x44,0x38,0x38,0x06,0xD1,0xF8,0x8E,0x72,0x55,
0x7A,0xB5,0x3B,0xAA,0xBB,0x00,0x2D,0x6F,0xFA,0x6B,
0x1D,0x90,0x2B,0x02,0xF4,0xBB,0xDE,0x6C,0xC7,0x9F,

};
const uint8_t refAES_CBC_128[]={
0x9E,0xB2,0x93,0xCF,0xA3,0xF3,0x9F,0x22,0xAB,0x7D,
0xBB,0x11,0xF8,0xD5,0xD0,0xE7,0x76,0x6F,0xCD,0xF5,
0x24,0xF2,0xEB,0x75,0x01,0x33,0x66,0xD0,0x8B,0x38,
0xB1,0x06,0xDA,0xD7,0xFA,0x4D,0x99,0x19,0x9F,0x8F,
0xE7,0xDE,0x06,0xC8,0xE3,0x0E,0x52,0x42,0x37,0xCE,
0x85,0x51,0xBA,0x01,0x6F,0x3F,0xB5,0x33,0xF5,0xF6,
0x2A,0x87,0x04,0xB1,0x2C,0xB7,0x0A,0x0E,0x42,0x9F,
0xCE,0xCA,0x09,0x21,0xB0,0xBD,0x09,0x82,0xEF,0x37,
0xAF,0x93,0xE0,0xF4,0x4B,0x15,0x35,0xB5,0x80,0x52,
0x0B,0xCA,0xA7,0x0C,0x66,0x85,0x6C,0x32,0xAF,0x2E,
0x82,0xED,0x44,0xC0,0x0D,0xE1,0x73,0xE2,0xD4,0xEB,
0xD9,0x08,0x64,0x09,0x55,0x00,0xB0,0xD8,0x5E,0x9E,
0x72,0xCC,0x44,0xA7,0xBA,0x31,0xCB,0xC2,0xCA,0xB0,
0x32,0x7C,0xEF,0xC1,0xE2,0x1A,0x68,0xC4,0x0C,0x5B,
0x1C,0x63,0xBC,0xFF,0x47,0xC4,0x01,0xA8,0x7B,0x16,
0x41,0xA0,0x43,0x87,0x06,0x0B,0x19,0x0C,0x72,0x4B,
0xED,0xEA,0x5A,0x5E,0x0A,0x14,0xC9,0xB4,0xDF,0xEC,
0x57,0x01,0x37,0x3D,0xCC,0x97,0x07,0x4C,0x48,0x64,
0x78,0xAB,0x5B,0x23,0xBF,0xE4,0x5C,0xC2,0xB4,0x06,
0xEC,0x75,0x18,0x56,0x70,0x6C,0xCF,0xC2,0x86,0x7F,
0xD5,0xBB,0x32,0x8F,0x9E,0x63,0x45,0x7B,0xD8,0x87,
0x1C,0x08,0xA4,0x51,0x6F,0x34,0x49,0x64,0xEB,0x16,
0x0B,0x95,0xB6,0xCB,0x75,0x27,0x4B,0xE3,0x15,0x2D,
0x9E,0x49,0xF1,0x09,0xAC,0xE0,0x70,0x34,0x59,0x6B,
0xE8,0x01,0x13,0x65,0xA5,0x43,0x7E,0xD6,0xBD,0xE7,
0x59,0x68,0x83,0x7F,0x85,0x56,0xAF,0x91,0x69,0xDE,
0x2E,0x79,0x3F,0xA7,0x82,0x5B,0x91,0xA2,0x81,0x26,
0xAC,0xEC,0xBF,0x25,0x8E,0x03,0x03,0x3E,0x38,0xC4,
0xC6,0x7B,0x74,0xFD,0x9B,0x56,0x92,0xA1,0x01,0x8A,
0xBE,0xB0,0xEE,0x76,0x80,0xC8,0x72,0xBF,0xCE,0xCE,
0xE2,0xF6,0xF7,0xC6,0xE2,0x68,0x3E,0xA6,0x06,0x7A,
0x7F,0xE8,0xF8,0xCA,0x15,0xA5,0xCA,0xC0,0x41,0x15,
0x87,0xF8,0xC9,0xFE,0xBB,0x64,0xDC,0xF7,0x36,0x18,
0x16,0xC6,0x30,0xCA,0xAA,0x47,0x9A,0xD0,0x0D,0x19,
0xF6,0x95,0xE1,0x55,0x15,0x0A,0xCA,0xED,0xBF,0x01,
0x22,0xEA,0x3F,0xF1,0x95,0x0F,0x21,0x18,0x3F,0xA6,
0x6E,0xB2,0x3D,0x01,0x8F,0x3B,0x3B,0x5E,0x4E,0xFA,
0xE1,0x76,0x50,0x3A,0x29,0xAE,0xB1,0x92,0x65,0x51,
0x5E,0xA7,0x1B,0x08,0x06,0x6E,0x06,0x5F,0xFD,0x87,
0xF8,0x23,0xE9,0xED,0x6E,0x38,0x6F,0x30,0x78,0x6E,
0x8D,0xB6,0x7A,0x8F,0x40,0x37,0x18,0x0F,0xD1,0x7E,
0xB7,0xF3,0x4E,0xFE,0x8F,0x0B,0x5A,0xC0,0x47,0xF7,
0xB9,0xB7,0xAD,0xEC,0x87,0x3D,0xB1,0xE9,0x7F,0x11,
0xCD,0x8F,0x08,0xE8,0x2A,0x9A,0x08,0xC4,0xE3,0xB2,
0x9A,0xCB,0x9C,0xA9,0xCD,0x14,0xC6,0x9C,0xF1,0x92,
0x49,0xC6,0xF2,0xC9,0xC0,0x43,0xF5,0xCE,0x38,0x82,
0xD5,0x41,0x31,0x96,0xB7,0x27,0xC6,0x5C,0x15,0x0E,
0x78,0x5E,0xEB,0xE1,0x89,0x1A,0x5C,0xC4,0xEE,0xF0,
0x53,0xD6,0x60,0x90,0xC8,0xB3,0xE5,0x5D,0x5F,0xD0,
0x52,0xCD,0xCA,0xC8,0xB9,0xA3,0x43,0x4E,0x6A,0xED,
0xEE,0x03,0xC8,0x22,0xE0,0x11,0x15,0x53,0xB8,0x62,
0x6B,0x0A,0x9F,0x90,0x4F,0xF6,0x6C,0x24,0xED,0xFB,
0x0E,0xF0,0x1F,0x1F,0xAB,0x72,0xBD,0x54,0xCC,0xDF,
0x8B,0x86,0x5C,0xC9,0xEF,0x41,0x1B,0xC6,0x67,0x57,
0xA7,0xDD,0xF2,0x0D,0x1D,0x02,0xD7,0xF1,0x90,0xE3,
0x3E,0xE4,0x9F,0xEA,0x6D,0x21,0x4D,0xCA,0x33,0xE0,
0x09,0xB6,0xEB,0xC5,0xE8,0xF2,0x87,0x0D,0x40,0x7A,
0xDC,0x98,0x28,0x0B,0xFF,0xD2,0x62,0x76,0xF0,0xDB,
0x40,0x27,0xB0,0x60,0x05,0x27,0x27,0xF5,0xE5,0xD2,
0xE0,0x4B,0x2D,0x1F,0x7B,0x79,0x8B,0xE4,0x4F,0xFD,
0xC0,0x69,0xEB,0x87,0x8B,0xCB,0xCB,0xB8,0x8E,0x17,
0x8B,0xF0,0x31,0x6B,0x5B,0x92,0x41,0xB5,0xA5,0x98,
0xCF,0x2B,0x4C,0xC2,0x26,0x4D,0x90,0xE4,0x9B,0xD2,
0xAB,0x5C,0x06,0x1F,0x38,0x36,0x35,0xB5,0x2F,0x9D,

};
const uint8_t refAES_CBC_192[]={
0x62,0xD5,0x8D,0x83,0xA0,0xF5,0x6D,0x48,0xF5,0xD2,
0x46,0x3C,0x31,0x96,0x88,0xFB,0x17,0x77,0x4B,0x59,
0xBE,0x56,0xBE,0x27,0xB4,0x54,0x09,0xA0,0xF3,0x22,
0x0C,0xAD,0x98,0x6E,0xB9,0xE5,0x73,0xDB,0x02,0xD1,
0x9C,0x2B,0x24,0x1F,0x16,0x31,0xED,0xED,0x11,0xB4,
0x7C,0x1E,0x5D,0xBA,0xFC,0xA8,0xC3,0xCC,0x22,0x0F,
0xDF,0x3E,0x86,0xB3,0x98,0x40,0x82,0x80,0x84,0xFD,
0xAB,0x84,0xF8,0x53,0x86,0x31,0x7E,0x85,0x2E,0x3F,
0xE1,0xB7,0xAD,0x5D,0x7A,0x48,0x0D,0xF5,0x4F,0xDA,
0x0A,0x52,0x1A,0x8D,0x9E,0x63,0xD2,0xA7,0xDA,0x0D,
0x95,0xD7,0x85,0x00,0x11,0xDC,0xAA,0x07,0xBF,0x02,
0x29,0xCB,0x96,0x8F,0x24,0x02,0x74,0x0E,0x6A,0xA6,
0xDA,0x5C,0x8D,0xD0,0x4E,0x92,0xE5,0x63,0x84,0x1B,
0x00,0xA5,0x54,0xE6,0x50,0x4C,0x6D,0x0E,0x10,0x93,
0x75,0x31,0x26,0x64,0xD7,0x91,0x3E,0xE1,0xF1,0xA0,
0xA5,0x3C,0xCD,0x1F,0x6A,0x9B,0x51,0xE2,0xA7,0xA1,
0xFC,0x01,0xD9,0xA1,0xF0,0xE0,0xA6,0x38,0x79,0x74,
0xC8,0x51,0xCE,0x6A,0xEC,0x7C,0xA8,0xC1,0xBA,0x2C,
0x1F,0x94,0x32,0xF0,0x9A,0xBB,0x60,0x54,0xCE,0xEE,
0xC2,0x95,0xA6,0x6C,0x99,0xE2,0xB7,0xCB,0xCA,0x43,
0x23,0x5A,0xA3,0x16,0x9A,0xBA,0x33,0xBE,0x09,0x72,
0xE5,0x7A,0x7F,0x57,0xB1,0xC5,0xC8,0xB6,0x83,0x37,
0xEC,0x94,0xBB,0x39,0x12,0x5B,0x5E,0x36,0xA6,0xC5,
0x9C,0x2B,0x32,0xE3,0x2B,0xCB,0x72,0x64,0x11,0x88,
0x05,0x97,0x59,0x20,0xCB,0x34,0xC2,0x55,0x7B,0xE2,
0x63,0x4C,0x05,0xCF,0x68,0x82,0x34,0x18,0x5A,0x1A,
0x35,0xAC,0x3C,0xE7,0x43,0x06,0x68,0x9B,0xE9,0x4D,
0x4C,0x8A,0xD9,0xCF,0xDD,0x76,0x68,0x12,0x52,0x97,
0xE0,0x6A,0x27,0x51,0x5D,0x84,0x3F,0x61,0x56,0x12,
0xE7,0x20,0xC0,0x80,0x61,0xD5,0x50,0x19,0x55,0x21,
0x7B,0x71,0x4C,0xC1,0x27,0x5A,0x3C,0x05,0xCA,0xBF,
0xFE,0xD8,0x84,0x70,0x63,0x71,0x59,0x8C,0xDC,0x01,
0x8C,0x8D,0x16,0xB5,0x85,0xF6,0x7B,0xA9,0x26,0x9F,
0xEA,0xAC,0xD6,0x3E,0x83,0xE9,0xE0,0x8C,0x06,0x00,
0x7E,0x36,0x49,0x85,0xBE,0x82,0xDD,0x68,0x98,0x90,
0x68,0xE4,0xDA,0x28,0x40,0xA9,0x71,0x83,0xEC,0xCC,
0x10,0x4A,0xC3,0x51,0x99,0x16,0xC8,0x63,0xF1,0x45,
0xF6,0xAD,0x8E,0xE9,0x2D,0xC0,0x20,0xA3,0x5F,0x9A,
0xCD,0xD7,0xB2,0x2D,0xC5,0xF5,0x67,0x53,0xB0,0xE5,
0xFB,0x51,0x8A,0x5D,0x75,0xE5,0x40,0xF4,0x5E,0xA5,
0xA5,0x98,0x69,0x26,0xC5,0xFF,0x05,0xE7,0x3A,0x3D,
0xB3,0x01,0xF6,0xF6,0xA8,0x21,0x9F,0xA4,0x67,0xB1,
0xA2,0x4A,0x45,0x74,0x18,0xC5,0x5B,0x31,0xA4,0x9D,
0x57,0x69,0xEF,0xCD,0xD7,0x81,0x4A,0xF8,0x3A,0xFF,
0xBD,0x9E,0x5D,0xBC,0x08,0x84,0x50,0x8C,0x21,0x80,
0x65,0x15,0xF4,0x50,0x94,0x65,0x8E,0xE9,0x6A,0xEE,
0x63,0xF8,0x56,0x4C,0x89,0x16,0x3F,0x70,0x4C,0x57,
0xF2,0x64,0xCB,0x86,0x5A,0x3E,0x84,0x52,0x7F,0xEA,
0x67,0xE7,0x96,0xCB,0x3F,0x9F,0xFF,0xDB,0x59,0xE7,
0x33,0xE9,0xCB,0x73,0xAB,0x80,0x90,0x4C,0xD8,0xCF,
0x3C,0xE2,0xA1,0xCF,0xEA,0xBE,0x60,0xD7,0xA6,0x4C,
0x9A,0x08,0x64,0x22,0x85,0xC4,0x06,0x8E,0x6B,0x44,
0x10,0x8F,0xC2,0x9B,0xEE,0x4C,0x30,0xFB,0xC2,0x71,
0x63,0x06,0x76,0xF0,0x79,0xE8,0xF0,0x70,0xDE,0x48,
0xB8,0x8A,0x5D,0x41,0x2B,0x4A,0x0C,0x7F,0x8E,0xBF,
0xAF,0x5F,0xB3,0x28,0xFD,0x01,0xCF,0xCE,0xBA,0xA7,
0x1B,0x9A,0xBC,0xD0,0x62,0x5F,0xB6,0x63,0x5A,0xC6,
0x74,0xE0,0xE4,0x20,0xCE,0x9B,0xC6,0xAA,0x0F,0x60,
0xB1,0xD3,0x54,0x39,0x2E,0x42,0x68,0x46,0x6F,0xBE,
0x1D,0x68,0xF4,0x28,0x66,0xDE,0xC3,0x81,0x03,0x81,
0x18,0x77,0xAD,0xD2,0xEC,0x0D,0x91,0xD0,0x0F,0x35,
0x29,0x79,0xA4,0xDE,0xD8,0xC5,0xBD,0x4D,0xEA,0xFC,
0xAF,0x5D,0xA1,0x31,0x90,0xBA,0x92,0x1A,0x8F,0x93,
0x94,0xFE,0x6E,0xC3,0xEB,0xEC,0x37,0x77,0x35,0x59,

};
const uint8_t refAES_CBC_256[]={
0x0E,0x02,0x38,0x69,0x61,0x5C,0x16,0x1F,0xA8,0xE5,
0x12,0x40,0x87,0xF7,0xAE,0xB2,0xCC,0xE5,0x54,0x0E,
0xCC,0x12,0xCF,0x94,0x3E,0x92,0xE7,0x6C,0x9A,0x11,
0x9E,0x76,0x71,0xC5,0xC0,0xE5,0x34,0xBB,0x6C,0x95,
0xA7,0x63,0xD1,0x95,0x19,0x44,0xCB,0x85,0x17,0x92,
0xB4,0x23,0x22,0x54,0xAB,0x76,0x1F,0xE4,0xB1,0x8E,
0x1D,0xF2,0x19,0x21,0xA6,0x65,0xAA,0x14,0x60,0xAF,
0xD9,0x11,0x6F,0x79,0xD1,0xCE,0x5E,0xAF,0x7D,0xE0,
0x49,0x00,0x2C,0x17,0x97,0xA5,0x73,0x4E,0x21,0xB1,
0xBB,0xF5,0x82,0xC9,0xF7,0xAA,0x19,0x4B,0x83,0xE3,
0xA3,0xEF,0x31,0x4A,0xE6,0xB2,0x98,0x8F,0x8D,0xD3,
0x01,0x56,0x4D,0x90,0x10,0x90,0x6B,0xBD,0x35,0x06,
0x25,0x6D,0x03,0x9B,0xED,0xBC,0x78,0xA1,0x6E,0x73,
0x79,0x25,0xAD,0x8A,0x56,0x2C,0x93,0xAC,0x1F,0x15,
0xA0,0x70,0xD3,0xFA,0xA6,0x1D,0xE0,0x41,0x88,0x97,
0xE2,0xBA,0x76,0x98,0x6A,0xBA,0x86,0xFE,0x1A,0x71,
0x52,0x61,0xBB,0x80,0x7A,0x77,0xE2,0x7E,0x64,0xD5,
0xEE,0xFC,0x33,0x9B,0x3E,0x53,0xB2,0x22,0xF8,0xD3,
0x5A,0x65,0xC8,0x6F,0x3A,0xC0,0xFB,0xAF,0xD4,0xD9,
0x29,0x92,0x30,0x3E,0xB1,0x35,0x7D,0x27,0x77,0xA4,
0xF1,0x17,0x48,0xE6,0x5C,0x55,0x48,0xE6,0x2B,0x83,
0x57,0x0E,0xDE,0xBA,0xCA,0x39,0x1C,0x6A,0x7C,0xBA,
0x01,0x82,0xE1,0x2E,0xC7,0xB0,0xD1,0xBF,0xF1,0x1B,
0xB8,0x3C,0x6E,0x02,0xA7,0xFF,0xC0,0x3E,0xEA,0xF9,
0x50,0xA7,0xF9,0x1A,0xF7,0xDA,0x65,0x26,0xFF,0x37,
0xCA,0x50,0x59,0x7A,0xA5,0x75,0x8E,0x79,0xFD,0xE6,
0xA1,0x53,0x44,0x49,0xA9,0x5C,0x81,0x6A,0x7D,0x07,
0x17,0xE5,0x12,0x3B,0xE3,0x80,0x95,0x76,0x6D,0x35,
0xDD,0x42,0xBF,0xE7,0xD5,0xFF,0xB6,0x7F,0xEA,0x25,
0x3E,0xCF,0x64,0x9E,0xA2,0x48,0xE8,0x65,0x4B,0x65,
0x57,0xE4,0xD7,0x2A,0xC3,0x7B,0x48,0xA1,0xBE,0xFB,
0x33,0x54,0xD8,0xA4,0x0D,0x16,0x08,0xCC,0xB3,0xC7,
0x21,0xA8,0xD8,0xAE,0x60,0x29,0x2E,0xF5,0x8C,0xBD,
0x6C,0x0F,0x04,0xDE,0x9D,0x52,0xA8,0xCD,0x90,0xF9,
0x9D,0xC5,0xDE,0x63,0x1C,0xF7,0x25,0xF5,0xFA,0x3E,
0xC8,0xFA,0x4D,0x5A,0x72,0x84,0xF7,0x86,0xF3,0xBA,
0x4E,0x52,0x22,0x8B,0x3D,0x85,0xB3,0x04,0xEF,0x49,
0x7E,0xB7,0x42,0x25,0x48,0xC9,0xF0,0x26,0xB7,0x87,
0x57,0x84,0xFC,0x7C,0xA8,0xC1,0x08,0xC5,0xBD,0x0F,
0x5B,0x59,0x62,0xCD,0xDC,0x48,0x4A,0x1D,0xFB,0x78,
0x05,0x40,0x16,0x9C,0x7B,0xCF,0x50,0xF1,0xE5,0x16,
0x24,0xD4,0xA2,0xBF,0xAC,0x6A,0x0F,0x45,0x22,0xDB,
0x51,0x3A,0x65,0xA3,0x7C,0x2B,0x1C,0xAF,0x6F,0x85,
0x8F,0xA3,0xD3,0xE4,0x80,0x6C,0x73,0xA5,0xDC,0xC9,
0x9C,0x74,0x68,0xE6,0x17,0x1E,0x57,0x42,0xA9,0x57,
0xE1,0xE0,0x03,0xF4,0xD3,0x10,0xC6,0xBF,0x4F,0x89,
0xD1,0x6E,0xB2,0xBF,0xFB,0x43,0xCB,0x6B,0x96,0x80,
0x44,0xF5,0x70,0x26,0xD1,0xFF,0x1C,0x74,0x04,0x4D,
0x48,0x17,0xFB,0x37,0xA8,0x97,0x96,0x15,0xD0,0xC8,
0x88,0xA6,0x5D,0x1B,0x34,0xCE,0xE9,0xA0,0xAD,0x34,
0xE9,0x9A,0xF4,0xA2,0x24,0x71,0x06,0x52,0xA1,0xC8,
0x16,0xCE,0xB2,0xE2,0xEC,0xAC,0x31,0x5F,0x93,0x64,
0x8C,0x3E,0xF4,0xC5,0xED,0x62,0xD3,0xDD,0xB8,0xB6,
0x2C,0x97,0xFC,0x11,0x19,0x91,0xBB,0xE5,0xB7,0xE7,
0xE5,0xD2,0xDA,0x39,0xE1,0x5A,0x63,0x16,0xA0,0x46,
0x1A,0xE5,0x79,0x78,0x78,0xAE,0x2E,0xB2,0xB3,0x97,
0xF0,0xC6,0x87,0x0F,0x2F,0x39,0x46,0x2D,0x45,0xFE,
0x34,0xD4,0xA9,0x9F,0x51,0xDA,0x95,0xD7,0x6E,0xCA,
0x0C,0x25,0xD6,0x3D,0x50,0x6A,0x40,0x3E,0x48,0x40,
0xC9,0xAD,0x80,0x47,0x93,0x33,0x32,0x8E,0xE6,0xD4,
0xAF,0xAA,0xF4,0xBD,0x9F,0xA7,0xDE,0xBA,0x95,0x30,
0x2B,0xE2,0xF0,0xFE,0xE4,0x90,0xB3,0x98,0x89,0x7E,
0x68,0xA0,0x94,0x44,0x27,0xBF,0x08,0xC4,0x80,0x7D,
0xB3,0xB3,0x64,0x30,0xE7,0x59,0x9D,0x98,0x3C,0xDC,

};
const uint8_t refAES_CTR_128[]={
0xFF,0x50,0x83,0x66,0x68,0x80,0x52,0xE8,0xAE,0x43,
0xC1,0xCC,0x8D,0x60,0x9C,0xF9,0x11,0xA6,0x1F,0x82,
0xF1,0xD9,0xFF,0x23,0xAF,0x47,0xF1,0xCE,0x99,0xA1,
0xDD,0xD2,0x82,0xAD,0x44,0x96,0x73,0xA1,0xB2,0x0B,
0x2E,0x30,0x37,0x89,0x4C,0xEC,0x20,0x73,0x29,0xE0,
0x5D,0xCD,0xAE,0x32,0x25,0xF3,0x14,0xB8,0xB3,0x98,
0x55,0x44,0xE5,0x12,0x47,0xD1,0x82,0x37,0xDB,0x9A,
0x1B,0x82,0x0A,0xF7,0x66,0xCA,0x4F,0xC0,0xB7,0xC9,
0xC8,0xD6,0xC9,0x0E,0xAE,0xC3,0x69,0xDB,0x3D,0x56,
0xC1,0x0E,0x74,0x54,0x1A,0xA1,0x79,0x90,0x1F,0xC4,
0x10,0xA8,0xFA,0x0E,0x4C,0xD8,0xD1,0x15,0x0C,0x9D,
0x88,0x1C,0xDE,0x6C,0x4D,0x31,0x1C,0xCA,0x06,0xFC,
0xC4,0x0B,0x40,0xC7,0xEF,0x0F,0x7C,0x21,0x90,0xAE,
0xB1,0x8F,0x1B,0xC9,0x7B,0xA6,0xF7,0xB9,0x66,0xFE,
0xED,0x5C,0x6C,0x2B,0xD1,0x9A,0x76,0x89,0xEC,0xC5,
0xE2,0x97,0x71,0x32,0x8D,0xE3,0xAE,0xF4,0x8B,0x4C,
0x8E,0x6A,0xCC,0xB6,0xC9,0xAD,0xE2,0x59,0x82,0xEB,
0x31,0xB2,0xA3,0xF7,0x61,0xC6,0xA9,0x00,0x82,0xA4,
0x9E,0xF2,0x51,0xB0,0xDE,0x5A,0xF9,0x79,0x3D,0x17,
0xFD,0xE1,0xA0,0xAD,0x22,0x72,0x41,0xC3,0xB6,0xD0,
0xDC,0xE3,0xD5,0xDB,0xAA,0x83,0x77,0x80,0xD0,0x8B,
0x14,0x3C,0xE4,0x66,0x7B,0xC4,0x15,0x80,0x19,0x9D,
0x22,0x13,0xE6,0x82,0x14,0xDC,0x73,0xC4,0x1D,0xBC,
0x79,0x7A,0x84,0x07,0xCD,0x46,0x96,0x0C,0x42,0xFA,
0xB7,0xD2,0x5B,0xA3,0x0A,0x86,0xDD,0xAD,0x07,0xCE,
0x11,0xE8,0xC6,0xAC,0xF3,0xDF,0xCB,0x80,0x7C,0x54,
0x2B,0xE2,0x12,0xCC,0xFF,0xC0,0x20,0xFF,0x47,0x1F,
0x6A,0x46,0x4A,0x3F,0xDD,0x65,0x15,0x5D,0xC8,0x3A,
0xDD,0x39,0x8C,0xAB,0x2E,0x34,0x5D,0x17,0xF9,0x4C,
0x92,0x6D,0xA7,0x8A,0x32,0x2B,0xD7,0xCF,0x17,0xDC,
0x48,0xE5,0xAA,0x31,0x3E,0x8C,0xCC,0x29,0x7A,0x5A,
0x60,0x92,0xC8,0x71,0x16,0x92,0xAE,0x1C,0x70,0x82,
0xAA,0x04,0x42,0xAE,0x84,0x8B,0x88,0x15,0x10,0x80,
0x14,0xFD,0xAD,0xBB,0x12,0x56,0x2E,0x8A,0xDF,0x9C,
0xC0,0x99,0x94,0xE1,0xB4,0xA2,0x04,0x90,0xAE,0xDD,
0xF9,0xE5,0xEF,0x5E,0x94,0x0B,0xAC,0x17,0x7C,0x59,
0x4A,0x55,0xC4,0x67,0xCE,0xFB,0x59,0xB2,0xAA,0x5B,
0xEE,0x07,0x59,0xC1,0xAB,0xB9,0xDE,0xB2,0xDE,0xFC,
0x75,0xAF,0xC0,0x93,0xAF,0x6D,0xC2,0x5B,0x16,0xE5,
0xAF,0x6B,0x27,0x91,0x9C,0x63,0x87,0x2D,0x3F,0xAD,
0x3F,0x19,0x17,0xDF,0xE3,0x71,0x65,0x84,0xDA,0xFD,
0x08,0x48,0x80,0x3F,0x9D,0x1E,0x4E,0x94,0xB4,0xA6,
0xFE,0xEE,0x47,0x6F,0x94,0x8F,0xF6,0x45,0x0A,0x33,
0x12,0xB2,0x76,0x86,0xBE,0x06,0xBA,0x78,0x0F,0x17,
0xEB,0x3E,0xAB,0xAE,0x7A,0xB0,0x6E,0x5D,0xAB,0x84,
0x67,0x9C,0x5E,0xDD,0xA9,0xDA,0x96,0x90,0x6E,0x84,
0x06,0x14,0x5C,0xC4,0x26,0xD3,0x38,0xE7,0x2D,0xFE,
0x1C,0xD2,0x9B,0x3C,0x34,0xA0,0xF5,0x24,0x2D,0x84,
0x92,0x4C,0x10,0x2C,0xCD,0xDA,0xDC,0x80,0xC9,0x04,
0x34,0xFD,0x3F,0x20,0x53,0xD0,0xE0,0xE6,0x33,0xD2,
0x17,0x82,0xB1,0x6A,0x48,0xC0,0xA9,0xDC,0x55,0x18,
0x68,0xBE,0xE5,0x3C,0x91,0xAD,0x28,0x76,0xAA,0xEB,
0x85,0xE1,0x71,0xD3,0x69,0x25,0xA0,0xE4,0x75,0xDA,
0x28,0x0B,0x60,0x26,0x4A,0x81,0x2E,0x50,0x3C,0x4E,
0xD9,0xBB,0xD8,0xF9,0x11,0x3A,0xC0,0xBB,0xDA,0x41,
0xDF,0xAC,0x1B,0x07,0x22,0xAC,0x54,0x05,0x99,0x4D,
0xCC,0xF9,0xDE,0x66,0xE9,0x57,0xE3,0xE3,0x4C,0x6A,
0x91,0xEB,0xE6,0xED,0x76,0x4A,0xE9,0xCD,0x04,0x8E,
0x51,0x32,0x43,0x5D,0x10,0x35,0x81,0x7F,0xEE,0x31,
0xB0,0x0B,0x8A,0xE5,0xE0,0x30,0x38,0xBA,0xAA,0x48,
0x43,0xC0,0xF9,0x60,0x79,0x6B,0x27,0xCD,0xF0,0x6E,
0x61,0x2C,0x0F,0x0A,0xB0,0xD5,0xA6,0x0A,0x50,0x51,
0x6C,0xD8,0x9F,0x3E,0x47,0x2F,0x39,0x42,0x61,0x5E,
0x68,0x1C,0xE6,0x56,0x8F,0x88,0x1D,0x46,0xBB,0x41,
0xD6,0x4D,
};
const uint8_t refAES_CTR_192[]={
0x7F,0x90,0x5A,0x78,0x3E,0x20,0x82,0xB7,0xBA,0xCE,
0xF7,0x14,0x40,0x93,0xF3,0x4C,0x80,0x03,0x13,0x1F,
0x76,0xEA,0xC2,0xA9,0xD2,0x45,0x88,0x60,0x98,0xC0,
0xD4,0xDB,0x01,0x9A,0x8D,0x88,0x55,0x85,0x01,0x03,
0x9E,0x20,0x0C,0xFA,0xE1,0xA8,0x11,0x1F,0x47,0xF5,
0x9A,0x58,0x47,0xB0,0x0A,0x54,0x80,0x81,0x9A,0x20,
0x7C,0x1A,0xBA,0x2B,0xDD,0xFA,0xFA,0x9A,0x42,0xA7,
0x7B,0xCE,0x9D,0x22,0x77,0x1B,0x3C,0xAC,0x39,0x85,
0xE1,0xCE,0x4D,0x6C,0x89,0x09,0x12,0xBD,0xBA,0x4C,
0x02,0x07,0x79,0x48,0x3E,0x70,0xC3,0x85,0x19,0xE6,
0xC0,0xA0,0x52,0x59,0x0E,0x19,0xC0,0xCC,0x88,0x3C,
0x0C,0xB8,0x37,0xE4,0x06,0x75,0x0C,0x43,0xF4,0xF4,
0xA4,0xA4,0xA9,0x2B,0xAB,0xC4,0x26,0xA5,0xC4,0x8A,
0xAC,0x16,0xC1,0x43,0x1D,0xDD,0x0B,0xF1,0xD5,0x4E,
0xDE,0xF9,0x27,0xE4,0x1B,0x3B,0xC5,0x29,0xC8,0xE5,
0x64,0xF7,0x0E,0xCE,0x43,0xD6,0x57,0xF7,0x1C,0x81,
0x81,0x2E,0xEC,0x47,0x8E,0xC1,0x01,0x23,0xAF,0x96,
0xD6,0x58,0x2B,0x1A,0xE0,0x84,0xA9,0xAF,0xFC,0xCF,
0xFD,0x42,0x66,0xC4,0x83,0x42,0xF1,0x3B,0x47,0xEB,
0x8D,0x92,0xCB,0x3C,0x5F,0x25,0xB6,0x29,0x5D,0x19,
0x0B,0x9A,0x5F,0xD0,0xD7,0xC6,0xBE,0xAE,0xC5,0x3B,
0xA5,0x07,0xBE,0x8E,0xC8,0xF3,0xAE,0x83,0xB6,0xF7,
0xA4,0x04,0xFC,0x0C,0x95,0x6C,0x6E,0xEB,0x82,0xB4,
0xE9,0x3D,0x38,0xAF,0x07,0xEB,0xFE,0x64,0x06,0xA2,
0x35,0x57,0x90,0x1C,0x0C,0x4F,0x94,0xCF,0x5B,0x54,
0x7A,0x0B,0x71,0x02,0x39,0x89,0xFA,0x83,0xFC,0x9C,
0xA4,0x16,0x67,0x44,0x69,0x4D,0x97,0x5A,0xC3,0x49,
0xE1,0x03,0x13,0xA7,0x44,0x86,0xC2,0x30,0xEF,0xBA,
0xBA,0xD6,0xCF,0xCC,0xF0,0x12,0x42,0x1E,0x22,0xE3,
0x9F,0xA2,0xE7,0xCD,0x39,0xCC,0x1C,0xAF,0xB0,0xFC,
0x2B,0x31,0xFA,0xD7,0x0A,0x23,0x48,0x5C,0x5B,0x53,
0x18,0x5A,0xC6,0x7F,0x14,0x21,0xF0,0xB3,0x89,0xFA,
0xEA,0xF3,0x62,0x51,0x75,0x09,0xAA,0x5A,0x7A,0x51,
0x23,0xA4,0x86,0xAF,0xFB,0xFF,0xDE,0x48,0xE2,0xEA,
0x13,0xFC,0x81,0x36,0x17,0x36,0xED,0xDF,0x71,0x9E,
0x58,0x65,0xFF,0x95,0xA4,0x95,0xF3,0x3D,0xEC,0xC7,
0xFF,0x19,0x73,0x89,0x2A,0x59,0x60,0x71,0x81,0x4F,
0x6B,0xB1,0xE4,0x35,0xCA,0x55,0x3B,0x47,0x24,0xBA,
0x14,0x76,0x21,0xEE,0x6D,0x97,0x1B,0x27,0x87,0x98,
0x39,0x11,0xEC,0x86,0x8F,0x21,0x61,0x87,0xF3,0xF9,
0xC1,0x85,0x5D,0x38,0xE9,0xC5,0x72,0xA1,0xA1,0x39,
0x75,0x41,0x39,0x36,0x32,0xDF,0x6D,0x16,0x5D,0x8A,
0x23,0x79,0x58,0x0B,0x08,0xF8,0x6C,0x75,0x00,0x2B,
0xE1,0x1D,0x24,0xEB,0x3B,0xD2,0x9E,0x50,0x94,0xC5,
0xE1,0x34,0xD0,0xE9,0x86,0x8E,0x48,0xD8,0x98,0xA4,
0xA3,0x47,0x44,0xD7,0xA8,0xDB,0xF9,0x7E,0x31,0x58,
0x14,0x24,0xFF,0x89,0x26,0x0D,0x08,0x12,0xC0,0x07,
0x94,0x51,0x0F,0xA8,0xF8,0x92,0xCB,0x85,0x19,0x5A,
0xDD,0xAD,0x4A,0x56,0xBA,0x5F,0x6E,0xAE,0x59,0x78,
0x0E,0x25,0x03,0x8A,0xA8,0x37,0xA9,0xB5,0x5F,0x08,
0x5D,0x1D,0xD9,0xBE,0xCE,0x63,0x91,0x9B,0x13,0x01,
0x7C,0x17,0xCE,0x8C,0x67,0xA7,0x17,0xBE,0x3B,0x51,
0x5E,0x01,0xC3,0xA6,0x87,0x2A,0x72,0x32,0x20,0x7C,
0x40,0x0A,0xA9,0x1D,0xB3,0x9F,0x61,0xF5,0x8B,0x2B,
0xD2,0xEB,0x28,0x07,0x83,0x9E,0x4E,0x7C,0xF5,0x75,
0x95,0xB3,0xF4,0x4C,0x1C,0xD5,0x92,0xF2,0x8B,0x04,
0xEF,0x5B,0x67,0x90,0xD1,0x4E,0x0F,0x7B,0x8D,0x6F,
0x31,0x64,0xED,0xBA,0x8A,0x47,0xD5,0x92,0x36,0x12,
0x15,0xD7,0x99,0x2C,0xD2,0x11,0x5B,0xB4,0x74,0x10,
0xF4,0x55,0xE8,0x7C,0x75,0xC3,0x85,0x01,0x4C,0xD2,
0x0E,0x62,0xEC,0x41,0xBE,0x45,0xE6,0x97,0xE4,0xE3,
0x9B,0x2F,0x7B,0x98,0x19,0x4E,0xC3,0xB5,0xD0,0x86,
0x63,0x61,0xD2,0x3E,0xB3,0x0A,0xAB,0x12,0x2A,0x64,
0x1E,0x9F,0xFD,0x66,0x66,0x4B,0xB0,0xFB,0xA0,0x36,
0xFA,0xDF,
};
const uint8_t refAES_CTR_256[]={
0x5F,0xD7,0x96,0x16,0x8E,0x0C,0x4E,0xD1,0x60,0x71,
0xF0,0xD6,0x8A,0x48,0x9C,0x69,0x7F,0xA7,0xFD,0x4A,
0x2E,0x6A,0x50,0x09,0xF6,0x51,0xA5,0xA0,0x26,0x04,
0x52,0xE9,0x4F,0x46,0xB2,0x83,0xB9,0x43,0x0F,0x69,
0xE9,0x27,0x84,0x8B,0x60,0x1C,0x4C,0xD4,0xC0,0xE5,
0x96,0x76,0x8D,0xB6,0xC6,0xAE,0x79,0x2F,0xAF,0xDC,
0x74,0xF5,0x6D,0x3B,0x53,0x6E,0x90,0x12,0x67,0xD0,
0xAB,0x2E,0xD5,0x1D,0x70,0x26,0x71,0xF9,0xF5,0x9C,
0xFD,0x80,0x49,0x16,0x96,0xA7,0x3B,0xAF,0xE0,0xB0,
0xDB,0x8F,0xAE,0x9D,0x7D,0x60,0x4F,0x16,0x3B,0x34,
0x54,0xA3,0xF6,0xE4,0xE4,0x71,0xCE,0x93,0x3C,0x92,
0xC5,0x53,0x3E,0x3E,0xC9,0xC5,0x4A,0x9C,0x26,0xC5,
0x37,0xCD,0x72,0x40,0x83,0xE1,0xC8,0xEE,0x0E,0xCE,
0x4D,0x37,0xB4,0xDC,0x70,0x5E,0xF0,0xE2,0x06,0xEB,
0xF0,0x82,0x6B,0x25,0x96,0x8C,0x50,0xBF,0xA3,0x68,
0x0A,0x5C,0x37,0xA8,0x3C,0x16,0xE6,0x1A,0xC6,0x94,
0x06,0xCB,0x70,0xBB,0xA6,0x57,0xF0,0x54,0xD2,0xB5,
0x08,0x05,0x9C,0x3C,0x96,0x47,0x36,0x57,0xC1,0xFC,
0x67,0x15,0x8F,0x2E,0x7F,0xCA,0xFA,0x59,0x77,0xEB,
0xD1,0xDC,0x71,0xFD,0x05,0xD0,0x98,0x19,0x83,0x87,
0xBB,0x48,0xE5,0xB5,0xC5,0xD3,0xEC,0x4B,0xD3,0xD1,
0xD3,0x13,0xFE,0x52,0xC1,0xD8,0xB0,0x51,0x7B,0x3C,
0x61,0xC0,0x4D,0xAC,0xAC,0x70,0xFE,0xFC,0xC1,0x17,
0xC1,0xC7,0x6B,0x54,0x23,0x2E,0x7A,0xA5,0x17,0xEB,
0x3E,0xC5,0xD7,0xB1,0x86,0x47,0x10,0x91,0x3A,0x58,
0x12,0xEE,0xAE,0x75,0xD5,0xE4,0x17,0xB5,0xB2,0xCA,
0xF8,0xE4,0x1C,0x3C,0x42,0xF2,0xDE,0xF3,0x70,0x86,
0x40,0x10,0xA5,0x14,0x14,0x37,0x51,0x51,0x20,0x4E,
0xB3,0x83,0xC2,0xB7,0x09,0x9E,0xD9,0x48,0x38,0xD0,
0x8C,0x99,0xDD,0x2C,0x18,0x87,0x19,0x8C,0xEC,0x65,
0x58,0x90,0xE1,0x02,0xB9,0x7E,0x46,0x6A,0xF6,0x95,
0x4B,0xB0,0x1E,0x96,0x11,0x05,0x8F,0x43,0xFB,0x39,
0xB9,0x47,0x3D,0x67,0x35,0xCA,0x89,0x97,0xFD,0x20,
0x85,0xDC,0x45,0xDB,0x85,0x4A,0xC8,0x93,0x15,0x07,
0x34,0x32,0x03,0x63,0xC7,0xDC,0xA5,0x9A,0x48,0x07,
0x15,0x8D,0xD8,0x85,0xC4,0xA1,0x68,0x37,0xB2,0x48,
0xB2,0x41,0x3C,0xA1,0x35,0x12,0xD4,0xF0,0x95,0xF7,
0xCB,0x8B,0x36,0xB2,0x79,0xC9,0x08,0xB3,0x9B,0x76,
0x6E,0xC2,0x81,0xAB,0x4D,0x55,0x89,0x40,0x5C,0x7E,
0x7F,0x56,0xFD,0xF0,0x40,0xB9,0xBD,0x83,0x78,0xF9,
0xF4,0xC3,0x0B,0x59,0x1F,0x92,0xEF,0x80,0x96,0x8F,
0xB9,0x20,0x53,0x9D,0x4A,0xE4,0x2C,0x55,0xBD,0xF2,
0xC5,0xE4,0xF4,0x48,0x56,0x46,0x41,0x4F,0x93,0x62,
0x8F,0xB1,0xC8,0x0A,0xF7,0xFB,0x8D,0x10,0x2D,0x13,
0xE4,0x2C,0x8F,0x32,0x8B,0xD4,0xD6,0x2E,0xE3,0x86,
0x3E,0xE4,0xF2,0x0C,0xD2,0x9C,0xD0,0x0C,0xC6,0x94,
0x29,0x62,0x0F,0x53,0xAF,0xD5,0x3B,0xA6,0x53,0x17,
0xB5,0x2A,0xDE,0xA0,0xB3,0x37,0x0A,0x13,0xDE,0xAA,
0x4F,0xB2,0x42,0xD7,0x72,0x35,0x20,0x55,0xBC,0x3B,
0x20,0x05,0xED,0x93,0x6B,0x40,0xD0,0x42,0xA8,0x1B,
0xD2,0x23,0xF5,0xBA,0x33,0xC6,0x2F,0x63,0x7D,0x83,
0x1E,0xAA,0x4B,0x19,0x27,0xC8,0x12,0x1B,0x46,0x77,
0x9E,0x21,0xC8,0x3B,0xA3,0xFF,0x8B,0x0C,0x0C,0x47,
0xD9,0xEA,0xA8,0x4F,0x40,0x42,0x5B,0x4A,0xEA,0xF8,
0x13,0x96,0xAF,0x66,0x90,0xE4,0x8D,0xB8,0x18,0x65,
0x67,0x21,0x97,0xFA,0xF1,0x67,0x11,0x2E,0x01,0x87,
0xE1,0x7E,0x18,0x48,0x4F,0x9E,0x84,0xDB,0x50,0xD8,
0xDB,0x63,0x4B,0x95,0x89,0x42,0x2E,0xE2,0xF6,0xD7,
0xD6,0xEC,0x92,0x55,0x39,0x25,0x89,0x94,0xE2,0x68,
0xE3,0x6B,0x76,0x60,0xA0,0xA1,0xA5,0x2F,0xA1,0x92,
0x8E,0xCE,0xED,0x72,0xA0,0x22,0x66,0x48,0xA2,0x24,
0xD2,0x1D,0x48,0xF2,0x1C,0xA6,0x2E,0x8E,0x78,0xAB,
0xDB,0x02,0x10,0x74,0x03,0x9B,0x5E,0x41,0xF0,0xA4,
0x81,0xF8,0x7B,0xC2,0x87,0x06,0x0F,0xED,0x44,0xAE,
0xB2,0x44,
};
const uint8_t refAES_CFB_128[]={
0xFF,0x50,0x83,0x66,0x68,0x80,0x52,0xE8,0xAE,0x43,
0xC1,0xCC,0x8D,0x60,0x9C,0xF9,0x00,0xA8,0x01,0xB3,
0xCE,0x04,0x10,0xA9,0xFC,0xD8,0x04,0x5E,0x03,0xAF,
0x4A,0xB6,0xC2,0xE2,0x1E,0xDF,0xFA,0xE0,0x2F,0x90,
0x8C,0x7A,0xC2,0x99,0xD4,0xA0,0x57,0x10,0xE8,0x03,
0x53,0x53,0x93,0x1C,0x6F,0x08,0xF0,0x90,0x27,0x1D,
0xFD,0x31,0xB9,0xD6,0x8C,0x26,0xBA,0x5C,0xD4,0x2A,
0x9A,0xF6,0x33,0x28,0x23,0xD2,0xC0,0x25,0xD5,0x70,
0x0F,0x4C,0x0E,0xDA,0xC0,0x2B,0xA6,0xD9,0x73,0xDD,
0x31,0x1B,0xBE,0xBE,0x2A,0x6D,0x1F,0x21,0xAC,0xE6,
0x1D,0x0F,0x10,0xC7,0x54,0x3E,0x4E,0x96,0xF3,0x7F,
0xF4,0x5A,0x6F,0x71,0x77,0x2E,0x23,0xF4,0xE4,0x38,
0x01,0x9A,0x14,0xF2,0x14,0x0B,0x58,0x73,0x2B,0xF1,
0x18,0x11,0xCD,0x4A,0x40,0x10,0x7C,0x44,0xE0,0xF6,
0x8C,0x68,0x41,0x68,0x53,0x5E,0x23,0x2A,0x31,0x08,
0x09,0xB3,0x73,0xE4,0x77,0x01,0x86,0xDC,0x89,0x00,
0xA1,0x46,0xF0,0xE8,0xEF,0x91,0xB0,0x21,0x76,0xD5,
0xBF,0xBF,0x8A,0x7A,0xD6,0xA5,0x2E,0xBF,0xDD,0x92,
0x2A,0x39,0x62,0x9C,0xA3,0xA9,0x35,0x8F,0x7D,0x85,
0x28,0x06,0x7F,0xC0,0x8A,0x6E,0xE2,0x1D,0xC8,0x81,
0x9E,0x14,0x3B,0xA1,0x3A,0xBB,0x14,0x0B,0x43,0x9C,
0x23,0xC2,0x2E,0x9F,0x45,0x4E,0x1F,0x75,0x3A,0x1F,
0x20,0x28,0x83,0x47,0x99,0xC2,0xA5,0x2D,0x98,0x98,
0x4F,0x26,0xEF,0x24,0x39,0xCB,0xD3,0x15,0x65,0x71,
0x81,0x8E,0xDB,0x4E,0x11,0xEF,0x74,0x2E,0x6E,0xDA,
0x2A,0xC4,0x42,0xD7,0xC5,0xDC,0xD5,0xA7,0x8A,0x22,
0x68,0x6A,0xEF,0xF8,0x3A,0xA1,0x5E,0x4D,0xD0,0x3E,
0x54,0xB5,0xDC,0x91,0xC6,0x00,0x68,0x56,0x73,0x21,
0x8F,0x36,0x3F,0xEC,0xD0,0xAE,0xD9,0x76,0xFD,0xB7,
0xD2,0x8E,0xBF,0xF8,0x3A,0x73,0x06,0xA8,0x42,0xBC,
0x3C,0x30,0xC2,0x7D,0xD5,0x27,0x1B,0x2B,0x09,0x47,
0x53,0x7C,0xF2,0xCB,0xE3,0xA4,0xC2,0x1C,0xFB,0x5A,
0x77,0xF6,0x6E,0xA5,0xFB,0x32,0x64,0xBC,0x8E,0x34,
0x0F,0x75,0xCB,0xD6,0xBF,0x05,0x93,0xBB,0xDC,0x2B,
0x4C,0x55,0xB5,0x4A,0x9E,0xF3,0x13,0xAC,0x7B,0x41,
0xE2,0x91,0x8F,0x3A,0x4E,0x6E,0x43,0x2C,0xFB,0xF0,
0xCB,0x56,0x8A,0xE4,0xF1,0x81,0xBF,0x47,0x2A,0xCF,
0xAD,0x3F,0xD1,0xEF,0x3C,0x87,0x10,0xA3,0x25,0x90,
0x7A,0xA7,0x58,0x87,0x45,0xBA,0x0C,0x76,0x9B,0x24,
0xEC,0x3B,0x63,0xFC,0x9A,0x7F,0xB7,0xEA,0x58,0x5B,
0x5A,0xAB,0x3F,0x4E,0x96,0xE9,0x8D,0x05,0xBF,0xE3,
0x59,0x0D,0x56,0x46,0x47,0xAB,0x18,0x3C,0x2E,0x5E,
0x7A,0x80,0xEA,0x40,0x34,0xBD,0x21,0x59,0x02,0x68,
0x3F,0xB2,0x58,0x9D,0xC8,0xEE,0xDE,0xA3,0xB0,0x8C,
0x5D,0x0A,0x8A,0xDC,0x15,0x7A,0xCB,0x72,0xA5,0x71,
0x07,0x62,0xBC,0xCB,0x1D,0xA7,0x30,0xAD,0x8A,0x41,
0xE3,0xE7,0xE9,0x42,0xDE,0x00,0x1A,0xD7,0xD5,0x2B,
0xC4,0x39,0x94,0xEC,0xC9,0x62,0x01,0x4F,0xAA,0x06,
0x28,0x82,0x6E,0x21,0xBD,0x5C,0x76,0xC7,0xF7,0x30,
0x1B,0xEF,0x85,0x0E,0x3D,0xED,0x14,0x4C,0x0D,0x14,
0xA6,0x87,0x52,0xFE,0xDC,0xB1,0x04,0xEC,0x34,0xBB,
0x92,0x67,0x06,0xBA,0xF4,0x9D,0x52,0xCD,0xF9,0xE1,
0x37,0xCB,0x7B,0x33,0x51,0x79,0x3E,0x76,0x75,0xDA,
0xA0,0xC3,0x9A,0xE0,0xA8,0xB2,0x68,0x26,0xD1,0xDC,
0x26,0xC1,0xB7,0x10,0xEA,0xF9,0x01,0xA9,0x41,0xD8,
0x0F,0xDE,0xAD,0x98,0x7B,0xE4,0x9C,0xDF,0xB2,0x0F,
0x11,0xA7,0x11,0xD8,0x61,0x24,0xD1,0x3D,0x7A,0xED,
0x55,0xC1,0x38,0x22,0x5F,0x03,0x12,0x3E,0x42,0xF0,
0x46,0x5C,0x8F,0x3A,0x98,0x8A,0x5E,0x88,0xA7,0x7E,
0x89,0x30,0xFF,0x8A,0xB0,0xF2,0x4C,0x58,0x0A,0x6F,
0xE1,0x27,0xDD,0x51,0xFA,0xCA,0x8F,0x59,0x77,0x17,
0xE8,0x3F,0x1F,0xF9,0x1E,0xC4,0xE7,0xC0,0x6C,0xFE,
0xA4,0xA8,0xEA,0x06,0xF4,0x51,0xB4,0xEA,0xBA,0x4A,
0x0D,0x9F,0xD0,0xD8,0xF2,0xB1,0x9D,0x34,0x2C,0x56,
0xE9,0xD5,
};
const uint8_t refAES_CFB_192[]={
0x7F,0x90,0x5A,0x78,0x3E,0x20,0x82,0xB7,0xBA,0xCE,
0xF7,0x14,0x40,0x93,0xF3,0x4C,0xC4,0x55,0x5B,0xCD,
0x46,0xA8,0xC9,0x29,0xE9,0xA7,0x86,0x4D,0x53,0xEA,
0x6C,0x7E,0xFA,0x11,0x5F,0xB3,0xA8,0xB6,0xD8,0x40,
0xFE,0xBB,0x05,0xB4,0xB0,0x9A,0x3C,0xC4,0x4E,0x01,
0x66,0xF6,0x27,0x28,0x7B,0x59,0x2A,0x34,0xF3,0x8B,
0xD9,0x8E,0x2E,0x03,0x38,0x56,0xE9,0xC9,0x5E,0x2B,
0x1F,0x9B,0x42,0x56,0xDD,0xE0,0x5E,0x7E,0x58,0x14,
0x9B,0x63,0xB7,0x81,0x31,0xED,0x19,0xC0,0xDE,0x3A,
0x13,0x22,0x4A,0x2D,0x90,0xAD,0x16,0x89,0xD2,0xAB,
0xB7,0xCA,0xAD,0x7A,0xF1,0xEB,0xAB,0x57,0x65,0x29,
0xE1,0x01,0xC3,0x7F,0xE0,0x08,0x28,0x22,0x60,0xBF,
0x4B,0x5F,0xCD,0xCE,0x81,0xBC,0x69,0x87,0x05,0x1D,
0x88,0xAB,0x85,0x2A,0x53,0x82,0x9A,0x14,0x20,0xCB,
0x37,0xEB,0x97,0x57,0xCC,0x92,0xCB,0x45,0xC1,0xC0,
0xA8,0xEC,0xDB,0x38,0x90,0x9C,0xD4,0xA4,0x49,0xBA,
0x2D,0xB7,0x90,0x00,0x50,0x7E,0x36,0x84,0x61,0x34,
0x47,0x8D,0x32,0x45,0x0F,0x2C,0x69,0xB9,0x39,0x05,
0x07,0xD8,0x20,0x26,0x46,0x7A,0x29,0x6A,0x41,0xC4,
0xF0,0x0B,0x0C,0x2B,0x22,0x4F,0x18,0x96,0x1E,0x74,
0x49,0x32,0xB0,0x00,0x82,0x69,0x4B,0xEB,0x27,0x9B,
0xA1,0x40,0x76,0x27,0x9A,0x59,0xAB,0x64,0x50,0xC3,
0x5E,0x8A,0x08,0x67,0x03,0x15,0xC3,0x12,0x29,0x10,
0xAE,0x23,0x33,0xC5,0x67,0xAB,0xA3,0xDE,0xE3,0x13,
0x0F,0xC9,0xCE,0x22,0xF4,0x83,0x3F,0xDD,0xFA,0xF6,
0x6E,0xBF,0xA9,0x5C,0xE5,0xE3,0xA1,0x37,0x70,0xFD,
0x2E,0x2C,0x69,0x2C,0x41,0x5D,0x31,0x31,0xC2,0x2E,
0xBD,0x48,0xA3,0x1F,0xBE,0x31,0x07,0x0A,0xEF,0x27,
0x22,0xFE,0x1E,0x36,0xC3,0x36,0xE8,0x1B,0x4F,0x74,
0x70,0x0E,0xDB,0x73,0x32,0x5E,0x21,0x70,0x92,0x0C,
0xAF,0x70,0xEA,0xC2,0x63,0x9D,0x67,0xC2,0xFA,0x0F,
0x50,0x23,0xE1,0x5B,0x13,0x78,0xA3,0xFD,0x37,0x87,
0x0A,0x23,0xF2,0xB6,0x1A,0x98,0xE2,0xE5,0x4A,0x9F,
0xC1,0x96,0xFF,0x3C,0x2E,0x8A,0xFF,0x53,0xF4,0x20,
0x23,0xD1,0x07,0xF0,0xFB,0x76,0x3B,0x6A,0x40,0x56,
0x2E,0x85,0xD7,0xC4,0xF8,0x4F,0x16,0x6F,0x91,0x34,
0x17,0x7B,0xF4,0xF7,0x0E,0xCF,0x3E,0x22,0xC3,0x87,
0x39,0xA6,0xB5,0x60,0x6C,0xE1,0x46,0x6C,0x19,0xF5,
0xE5,0x68,0x98,0xEB,0xE2,0xD0,0xAA,0xFF,0x2B,0xEC,
0x39,0x2E,0x23,0x8F,0x8E,0x35,0x5E,0x30,0xD5,0x4F,
0x5D,0x9B,0xF8,0xA1,0xA9,0xD6,0x1D,0x3F,0xB4,0xB4,
0xE4,0xE6,0x36,0x66,0x8B,0x1E,0x58,0xC6,0xCC,0x67,
0x53,0xDA,0x0A,0xC5,0x08,0xEC,0xC8,0xDD,0x35,0x9A,
0x1B,0xB5,0xC4,0xE4,0x8C,0xBD,0x41,0x85,0x4B,0x30,
0xE2,0x05,0xD9,0x74,0x63,0xA1,0x60,0xEF,0x8E,0xE4,
0x1B,0x78,0x89,0x3C,0xC3,0x60,0xC6,0x0F,0x61,0x98,
0xEB,0x09,0x96,0x23,0xCC,0x34,0x66,0xB0,0x4E,0xE1,
0x68,0x90,0xBC,0x0D,0x8F,0x30,0xFF,0x53,0x92,0x6C,
0xF7,0xB3,0x47,0xB2,0x6D,0xE3,0x8E,0x5E,0xC5,0x02,
0xC9,0x62,0xD5,0x97,0x3E,0x05,0xE0,0x7B,0xBD,0x43,
0xF5,0xD8,0xDE,0x85,0x25,0xDC,0xDC,0x41,0x76,0x04,
0x6E,0x03,0x07,0xF1,0xA2,0xBA,0x3B,0x3E,0x16,0x63,
0x09,0x3B,0x4C,0x60,0xC1,0x13,0x63,0xAC,0x31,0x99,
0xBD,0xFE,0x2C,0x4D,0x03,0xDF,0xAC,0xF5,0x97,0xFF,
0x28,0xC4,0x7E,0x0C,0x57,0x20,0x12,0xF3,0x34,0x44,
0xEE,0x1B,0xC5,0x79,0xC1,0x61,0x06,0x38,0x58,0x65,
0x89,0xFD,0xAF,0x77,0x69,0x49,0xA7,0x40,0x02,0x3F,
0xD8,0x0F,0x10,0x20,0x0F,0x35,0x19,0x09,0xF1,0xD6,
0xB9,0x33,0xAF,0xFE,0x81,0x6A,0x75,0x9E,0x98,0x24,
0x3F,0x6F,0x8F,0x4E,0xFC,0x72,0x08,0x7C,0xAF,0x56,
0x19,0x90,0x0D,0x56,0xF0,0x80,0x88,0x77,0xAA,0x16,
0x65,0x55,0x27,0x5B,0x4C,0x23,0x1C,0x04,0x46,0xB0,
0xA7,0x5D,0x68,0xD0,0x3D,0x8A,0xEF,0x73,0xEA,0xAF,
0x15,0x1D,0x2A,0xCC,0x86,0x42,0x64,0x54,0xBF,0x05,
0x98,0xFF,
};
const uint8_t refAES_CFB_256[]={
0x5F,0xD7,0x96,0x16,0x8E,0x0C,0x4E,0xD1,0x60,0x71,
0xF0,0xD6,0x8A,0x48,0x9C,0x69,0x70,0xB0,0x34,0x77,
0x3C,0xF7,0x27,0xFE,0xD2,0x46,0x63,0xE5,0x94,0x1A,
0xFD,0x2A,0xF9,0x81,0x5D,0xE0,0x67,0xB7,0xA9,0x43,
0x46,0x4F,0xE3,0x43,0xF6,0xBE,0x30,0xEA,0x54,0x49,
0xAC,0xC4,0xE1,0x45,0xB4,0x2A,0xDF,0x02,0x52,0x90,
0x37,0xCF,0x26,0x22,0xA8,0x84,0x98,0x03,0x2C,0xB8,
0xEA,0xB8,0x5E,0x9A,0xA1,0x50,0xF4,0x89,0xB6,0x78,
0xCA,0xC6,0xC8,0x6E,0xB8,0x0C,0x69,0xCC,0xC9,0xD5,
0x75,0xF6,0xB5,0xC5,0x1F,0x26,0xB2,0x97,0x9D,0xF6,
0x4D,0x68,0x08,0x47,0x76,0x6C,0xAF,0x03,0x5B,0xD7,
0x0D,0x75,0xAE,0x9D,0x35,0x8A,0x16,0xF0,0xB5,0xAB,
0x41,0x50,0xD7,0xDB,0x41,0x8F,0xD7,0x58,0x9C,0x5A,
0x76,0xEC,0xCD,0x7E,0x2E,0x6A,0xE8,0x79,0xBB,0x44,
0xFA,0x1E,0x17,0xF5,0xA6,0x5F,0xF5,0xF8,0x62,0x70,
0xF4,0x66,0xE2,0xF0,0x79,0x6A,0xBF,0xB6,0x9D,0xBB,
0x75,0x0C,0x5D,0x64,0xC3,0xE3,0x14,0xBE,0xE3,0x81,
0xD8,0x14,0x7C,0x59,0xE3,0xEE,0xEA,0x35,0x33,0xE6,
0x42,0x1C,0x0C,0x12,0xE1,0x51,0xE8,0xC8,0x24,0xBE,
0xDB,0x1C,0x00,0xC5,0x60,0x2D,0x5F,0x92,0xE7,0xD4,
0xD2,0x08,0x72,0xC5,0xC1,0x5C,0xBC,0x1B,0xD8,0x1E,
0xC3,0x38,0x28,0xDA,0xA3,0x30,0x61,0x5F,0x54,0xEA,
0x24,0x3B,0x80,0xDE,0x25,0xFE,0x6C,0x04,0x68,0x7B,
0x9E,0x79,0x1A,0xF2,0x85,0x39,0x5B,0x75,0xC5,0x72,
0x9B,0xB3,0x40,0xF5,0xA9,0xD8,0x5D,0x9F,0x74,0x66,
0xE2,0x02,0x58,0x10,0xB3,0x0A,0x34,0xB6,0x5F,0x95,
0xDF,0xEF,0xDE,0x25,0xCC,0x54,0x6F,0x29,0x57,0x46,
0xE2,0xE4,0x9C,0x17,0x0F,0x10,0x52,0x49,0x95,0x15,
0xE3,0xF7,0xA6,0x68,0xE2,0x54,0x47,0xDC,0x54,0xF2,
0x83,0x2B,0xB1,0x77,0x10,0xC0,0xD1,0x86,0x2D,0xC5,
0xE6,0x7F,0x72,0xCF,0xBA,0xBE,0x6E,0xA1,0x90,0xDB,
0xC5,0xC0,0x9C,0xB3,0xD5,0xE3,0xBA,0x85,0x00,0x8A,
0x5C,0x63,0x34,0xF5,0x66,0x23,0x28,0xD6,0x3A,0x68,
0x14,0xB3,0x34,0x20,0xA6,0xE8,0x63,0x72,0x00,0x18,
0xA5,0x69,0x12,0xBA,0x1C,0xA8,0x0E,0xDE,0xD7,0x10,
0xBE,0x10,0x7F,0x12,0xDC,0x55,0xEF,0x21,0xE2,0x73,
0x48,0x0D,0x8E,0x59,0x35,0x3A,0x5D,0x63,0x3E,0x7E,
0xDE,0x1D,0x71,0xF6,0x3B,0xD6,0x08,0xB5,0x64,0x74,
0xA0,0x82,0x9D,0xF1,0x43,0xDE,0xD9,0x9F,0x5D,0xC0,
0xBF,0x3E,0x90,0x36,0x60,0x74,0xF0,0xDE,0xBB,0x88,
0xDF,0xA7,0xD1,0x26,0x50,0xBF,0xA9,0x0C,0xC6,0xE2,
0xCB,0x8F,0x95,0xB7,0x8B,0xF7,0x1A,0x5E,0x68,0xED,
0x13,0x5D,0x53,0xED,0xBD,0x34,0xEA,0x37,0x03,0x0D,
0xCC,0x9F,0x67,0xF1,0xE4,0xED,0xD6,0x0A,0xEA,0x07,
0xFB,0x43,0x54,0x91,0x57,0xEF,0xFD,0x2B,0xF1,0x48,
0x82,0x4E,0x2C,0xF0,0x2B,0xB5,0x2F,0x9A,0xEA,0x84,
0xF1,0x48,0x44,0x9A,0x5E,0x29,0xDA,0xE0,0xAC,0x19,
0x5A,0xAB,0x67,0x09,0x96,0xE1,0x23,0x29,0xA0,0x31,
0x0F,0x24,0xE6,0x13,0x97,0x13,0x59,0xEA,0x21,0xA5,
0xDC,0xE9,0x12,0x1C,0x21,0x14,0xBC,0x3C,0x47,0xF5,
0xC1,0xCF,0x87,0x3B,0x52,0x01,0xD3,0x5F,0xDA,0xD5,
0x57,0x15,0xA8,0x56,0x3A,0x86,0xFE,0x63,0x4F,0x34,
0x85,0xAE,0x32,0x07,0x29,0x15,0xDA,0xCE,0xB5,0x5A,
0x07,0xD4,0x8C,0xAE,0x16,0x77,0xFF,0xB8,0xCA,0x08,
0x8F,0x06,0x96,0xC7,0x8A,0x0D,0xD0,0x95,0x38,0x8D,
0x34,0x0E,0x57,0x35,0x8B,0xEE,0x17,0x23,0x6D,0x91,
0xD6,0xEB,0x25,0x74,0x0C,0x0A,0x90,0x30,0x81,0x16,
0xA5,0xBE,0x83,0xF9,0xC4,0xA1,0xE6,0x44,0x5B,0x8F,
0xCA,0x4D,0x69,0xA6,0x77,0x3A,0x57,0x1E,0x4A,0x0C,
0xE8,0x9E,0x73,0xF4,0x35,0x09,0x2C,0x04,0xB4,0x24,
0xDF,0xED,0xB2,0x6F,0x41,0x54,0xC1,0x7D,0xC5,0xFF,
0xFE,0xD7,0x20,0x02,0x1F,0x60,0xB8,0xD5,0xFB,0xC6,
0x1F,0xEA,0x1C,0xDA,0xDD,0x5B,0x73,0x41,0x01,0xF6,
0x4F,0xF4,0xB2,0xE1,0x30,0xC6,0xEE,0x72,0xF0,0x5D,
0x34,0x2D,
};
