/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.common.exception;

import java.nio.charset.Charset;
import jp.co.ogis_ri.citk.common.exception.CitkApplicationException;
import jp.co.ogis_ri.citk.common.exception.CitkSystemException;
import jp.co.ogis_ri.citk.common.exception.IllegalRequestException;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.exception.RollbackSourceCallback;
import org.mule.api.transport.PropertyScope;
import org.mule.config.ExceptionHelper;
import org.mule.exception.AbstractMessagingExceptionStrategy;

public class CitkExceptionStrategy
extends AbstractMessagingExceptionStrategy {
    private static final String contentType = "text/html";
    private String encoding = "charset=Shift_JIS";
    private static final CitkLogger logger = CitkLogger.getLog(CitkExceptionStrategy.class);

    public CitkExceptionStrategy(MuleContext muleContext) {
        super(muleContext);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        Charset.forName(encoding);
        this.encoding = encoding;
    }

    public MuleEvent handleException(Exception e, MuleEvent event) {
        MuleEvent resultEvent = event;
        Throwable throwable = e.getCause();
        if (throwable instanceof CitkSystemException) {
            this.exceptionLogging(throwable);
            return this.setResult(resultEvent, throwable);
        }
        if (throwable instanceof CitkApplicationException) {
            this.exceptionLogging(throwable);
            return this.setResult(resultEvent, throwable);
        }
        return super.handleException(e, event);
    }

    private int getStatusCode(Throwable throwable) {
        if (throwable instanceof IllegalRequestException) {
            return 404;
        }
        return 500;
    }

    public MuleEvent handleException(Exception ex, MuleEvent event, RollbackSourceCallback rollbackMethod) {
        return super.handleException(ex, event, rollbackMethod);
    }

    private MuleEvent setResult(MuleEvent event, Throwable throwable) {
        event.getMessage().setExceptionPayload(null);
        String message = null;
        if (throwable instanceof IllegalRequestException) {
            message = ((IllegalRequestException)throwable).getMessageToPayloard();
            event.getMessage().setPayload((Object)message);
        } else {
            message = throwable.getMessage();
            event.getMessage().setPayload((Object)message);
        }
        event.getMessage().setOutboundProperty("Content-Length", (Object)message.length());
        event.getMessage().setOutboundProperty("http.status", (Object)this.getStatusCode(throwable));
        String contentTypeParam = "text/html; " + this.getEncoding();
        event.getMessage().setProperty("Content-Type", (Object)contentTypeParam, PropertyScope.OUTBOUND);
        return event;
    }

    private void exceptionLogging(Throwable t) {
        logger.error(t);
        Throwable lootThrowable = ExceptionHelper.getRootException((Throwable)t);
        logger.error(lootThrowable, "Caught exception in Exception Strategy: ", new Object[0]);
    }
}

