/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.common.log;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CitkLogger {
    private static final String OPERATION = "operation";
    private static final ResourceBundle message_rb = ResourceBundle.getBundle("citk-log-messages");
    private Log log = null;

    public static CitkLogger getLog(Class<?> clazz) {
        return new CitkLogger(clazz);
    }

    public static CitkLogger getLog(String clazz) {
        return new CitkLogger(clazz);
    }

    public static CitkLogger getOperationLog() {
        return new CitkLogger();
    }

    private CitkLogger(Class<?> clazz) {
        this.log = LogFactory.getLog(clazz);
    }

    private CitkLogger(String clazz) {
        this.log = LogFactory.getLog((String)clazz);
    }

    private CitkLogger() {
        this.log = LogFactory.getLog((String)OPERATION);
    }

    private String getMessage(String keyOrMessage, Object ... args) {
        String message = null;
        message = message_rb.containsKey(keyOrMessage) ? message_rb.getString(keyOrMessage) : keyOrMessage;
        if (args.length == 0) {
            return message;
        }
        return MessageFormat.format(message, args);
    }

    public void fatal(String keyOrMessage, Object ... param) {
        if (this.log.isFatalEnabled()) {
            this.log.fatal((Object)this.getMessage(keyOrMessage, param));
        }
    }

    public void fatal(Throwable t, String keyOrMessage, Object ... args) {
        if (this.log.isFatalEnabled()) {
            this.log.fatal((Object)this.getMessage(keyOrMessage, args), t);
        }
    }

    public void fatal(Throwable t) {
        if (this.log.isFatalEnabled()) {
            this.log.fatal((Object)t);
        }
    }

    public void error(String keyOrMessage, Object ... param) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)this.getMessage(keyOrMessage, param));
        }
    }

    public void error(Throwable t) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)t);
        }
    }

    public void error(Throwable t, String keyOrMessage, Object ... param) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)this.getMessage(keyOrMessage, param), t);
        }
    }

    public void warn(String keyOrMessage, Object ... param) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)this.getMessage(keyOrMessage, param));
        }
    }

    public void warn(Throwable t, String keyOrMessage, Object ... param) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)this.getMessage(keyOrMessage, param), t);
        }
    }

    public void warn(Throwable t) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)t);
        }
    }

    public void info(String keyOrMessage, Object ... param) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)this.getMessage(keyOrMessage, param));
        }
    }

    public void info(Throwable t, String keyOrMessage, Object ... param) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)this.getMessage(keyOrMessage, param), t);
        }
    }

    public void info(Throwable t) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)t);
        }
    }

    public void debug(String keyOrMessage, Object ... param) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.getMessage(keyOrMessage, param));
        }
    }

    public void debug(Throwable t, String keyOrMessage, Object ... param) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.getMessage(keyOrMessage, param), t);
        }
    }

    public void debug(Throwable t) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)t);
        }
    }

    public void trace(String keyOrMessage, Object ... param) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)this.getMessage(keyOrMessage, param));
        }
    }

    public void trace(Throwable t, String keyOrMessage, Object ... param) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)this.getMessage(keyOrMessage, param), t);
        }
    }

    public void trace(Throwable t) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)t);
        }
    }

    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }
}

