/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.forwarding.transformer;

import jp.co.ogis_ri.citk.common.exception.EndPointMappingException;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpoint;
import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpointResolver;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;

public class ForwardingOutboundTransformer
extends AbstractMessageTransformer {
    private static final CitkLogger logger = CitkLogger.getLog(ForwardingOutboundTransformer.class);
    private static final CitkLogger opLogger = CitkLogger.getOperationLog();
    OutboundEndpointResolver outboundEndpointResolver;

    public OutboundEndpointResolver getOutboundEndpointResolver() {
        return this.outboundEndpointResolver;
    }

    public void setOutboundEndpointResolver(OutboundEndpointResolver outboundEndpointResolver) {
        this.outboundEndpointResolver = outboundEndpointResolver;
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        String messageID = message.getMessageRootId();
        String targetKey = null;
        String authzResult = null;
        String path = null;
        path = (String)message.getInboundProperty("http.request");
        authzResult = (String)message.getSessionProperty("authz.result");
        path = path.substring(1);
        targetKey = this.getTargetKey(message, path);
        logger.debug("call resolve method [ muleMessageId : {0}, nameId : {1}, targetKey : {2}, authzResult : {3}]", new Object[]{message.getUniqueId(), message.getInboundProperty("nameId"), targetKey, authzResult});
        OutboundEndpoint outboundEndpoint = this.outboundEndpointResolver.resolve(targetKey, authzResult);
        if (outboundEndpoint == null) {
            throw new EndPointMappingException("E-0202", targetKey, authzResult, (String)message.getInboundProperty("nameId"), new Object[0]);
        }
        String address = null;
        String protocol = outboundEndpoint.getProtocol();
        String host = outboundEndpoint.getHost();
        String port = Integer.toString(outboundEndpoint.getPort());
        String appContext = outboundEndpoint.getAppcontext();
        address = this.buildRequestURL(path, targetKey, host, port, appContext, authzResult);
        opLogger.info("I-0301", new Object[]{messageID, protocol + "://" + address});
        message.setOutboundProperty("outBound.address", (Object)address);
        message.setOutboundProperty("outBound.protocol", (Object)protocol);
        return message;
    }

    private String buildRequestURL(String path, String targetKey, String host, String port, String appContext, String authzResult) {
        String address;
        if ("Permit".equals(authzResult)) {
            String request = StringUtils.remove((String)path, (String)(targetKey + "/"));
            address = host + ":" + port + appContext + request;
        } else {
            address = host + ":" + port + appContext;
        }
        logger.debug("address : " + address, new Object[0]);
        return address;
    }

    private String getTargetKey(MuleMessage message, String path) {
        String[] id = path.split("/");
        if (id.length < 2) {
            logger.debug("Invalid path : " + path, new Object[0]);
            throw new EndPointMappingException("E-0004", null, null, null, new Object[0]);
        }
        String targetKey = id[0] + "/" + id[1];
        return targetKey;
    }
}

