/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.forwarding.transformer.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jp.co.ogis_ri.citk.common.exception.EndPointMappingException;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.forwarding.transformer.EndpointUrl;
import jp.co.ogis_ri.citk.forwarding.transformer.OutboundEndpoint;

public class EndpointUrlBuilder {
    private static final CitkLogger logger = CitkLogger.getLog(EndpointUrlBuilder.class);
    private Map<String, String> settingDatas;

    public Map<String, String> getSettingDatas() {
        return this.settingDatas;
    }

    public void setSettingDatas(Map<String, String> settingDatas) {
        this.settingDatas = settingDatas;
    }

    public Map<String, EndpointUrl> build() {
        HashMap<String, EndpointUrl> endpointURLMap = new HashMap<String, EndpointUrl>();
        for (String name : this.settingDatas.keySet()) {
            String[] urls = this.settingDatas.get(name).split(",");
            OutboundEndpoint permit = null;
            OutboundEndpoint deny = null;
            logger.debug("name : " + name + ", urls : " + this.settingDatas.get(name), new Object[0]);
            try {
                permit = new OutboundEndpoint(new URL(urls[0]));
                deny = new OutboundEndpoint(new URL(urls[1]));
            }
            catch (MalformedURLException e) {
                throw new EndPointMappingException((Throwable)e, "E-0201", null, null, null, new Object[0]);
            }
            EndpointUrl endpointUrl = new EndpointUrl();
            endpointUrl.setPermit(permit);
            endpointUrl.setDeny(deny);
            endpointURLMap.put(name, endpointUrl);
        }
        return endpointURLMap;
    }
}

