/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.wssagents.jaxws.client;

import com.sun.identity.wss.security.handler.SOAPRequestHandler;
import com.sun.identity.wss.security.handler.SOAPRequestHandlerInterface;
import com.sun.identity.wss.security.handler.ThreadLocalService;
import com.sun.xml.messaging.saaj.soap.name.NameImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import org.w3c.dom.Node;

public class ClientHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final CitkLogger logger = CitkLogger.getLog(ClientHandler.class);
    private String wscProfile;
    private Map<String, String> citkCredentials;

    public Set<QName> getHeaders() {
        HashSet<QName> qnames = new HashSet<QName>();
        qnames.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse"));
        return qnames;
    }

    public boolean handleFault(SOAPMessageContext context) {
        logger.error("handleFault : " + context.getMessage().getSOAPPart().toString(), new Object[0]);
        return true;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("providername", this.wscProfile);
        SOAPRequestHandler handler = new SOAPRequestHandler();
        try {
            handler.init(map);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex, "initialization failed.", new Object[0]);
            throw new ProtocolException((Throwable)ex);
        }
        HashMap param = new HashMap();
        Boolean outboundMsg = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outboundMsg.booleanValue()) {
            return this.handleOutgoingRequest(context, (SOAPRequestHandlerInterface)handler, param);
        }
        return this.handleIncommingResponse(context, (SOAPRequestHandlerInterface)handler, param);
    }

    private boolean handleIncommingResponse(SOAPMessageContext context, SOAPRequestHandlerInterface handler, Map param) {
        logger.debug("Incomming Response : " + handler.print((Node)context.getMessage().getSOAPPart()), new Object[0]);
        try {
            handler.validateResponse(context.getMessage(), param);
            return true;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex, "validateResponse failed.", new Object[0]);
            throw new ProtocolException(ex.toString());
        }
    }

    private boolean handleOutgoingRequest(SOAPMessageContext context, SOAPRequestHandlerInterface handler, Map param) {
        logger.debug("Outgoing Request : " + handler.print((Node)context.getMessage().getSOAPPart()), new Object[0]);
        try {
            Subject subject = null;
            subject = (Subject)ThreadLocalService.getSubject();
            if (subject == null) {
                logger.debug("subject NULL", new Object[0]);
                subject = new Subject();
            } else {
                ThreadLocalService.removeSubject();
            }
            this.setCredentialInfo(context);
            handler.secureRequest(context.getMessage(), subject, param);
            return true;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex, "secureRequest failed.", new Object[0]);
            throw new ProtocolException(ex.toString());
        }
    }

    private void setCredentialInfo(SOAPMessageContext context) throws SOAPException {
        QName citk = new QName("citknamespace", "cred", "citk");
        SOAPEnvelope envelope = context.getMessage().getSOAPPart().getEnvelope();
        if (envelope.getHeader() == null) {
            envelope.addHeader();
        }
        SOAPElement element = envelope.getHeader().addChildElement(citk);
        element.addChildElement("nameId").addAttribute(NameImpl.createFromTagName((String)"value"), this.citkCredentials.get("nameId"));
        element.addChildElement("idpEntityId").addAttribute(NameImpl.createFromTagName((String)"value"), this.citkCredentials.get("idpEntityId"));
    }

    public void close(MessageContext context) {
    }

    public void setWscProfile(String wscProfile) {
        this.wscProfile = wscProfile;
    }

    public void setCitkCredentials(Map<String, String> citkCredentials) {
        this.citkCredentials = citkCredentials;
    }
}

