/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.wsp.cxf.jaxws.handler;

import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.wsp.cxf.jaxws.handler.AbstractWsHandler;
import org.apache.cxf.binding.soap.SoapMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.w3c.dom.Node;

public class WsHandler
extends AbstractWsHandler {
    private static CitkLogger logger = CitkLogger.getLog(WsHandler.class);

    @Override
    protected void handleSecureMessage(SoapMessage message, SOAPMessageContext context, ThreadLocal<Subject> cred, Subject subject, Map<Object, Object> sharedMap) {
        Boolean outboundMsg = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (!outboundMsg.booleanValue()) {
            this.setCredentialsToMuleMessage(context);
            this.handleIncomingRequest(message, context, cred, subject, sharedMap);
        } else {
            this.handleOutgoingResponse(message, context, cred, subject, sharedMap);
        }
    }

    private void setCredentialsToMuleMessage(SOAPMessageContext context) {
        Iterator elements;
        SOAPElement citkElem = null;
        try {
            elements = context.getMessage().getSOAPPart().getEnvelope().getHeader().getChildElements();
            while (elements.hasNext()) {
                SOAPElement tmp = (SOAPElement)elements.next();
                if (!"citk".equals(tmp.getPrefix())) continue;
                citkElem = tmp;
                break;
            }
        }
        catch (SOAPException e) {
            throw new ProtocolException((Throwable)e);
        }
        if (citkElem == null) {
            throw new ProtocolException("CITK-credentials are not existed.");
        }
        MuleMessage message = ((MuleEvent)context.get((Object)"mule.event")).getMessage();
        elements = citkElem.getChildElements();
        while (elements.hasNext()) {
            SOAPElement tmp = (SOAPElement)elements.next();
            if ("nameId".equals(tmp.getLocalName())) {
                message.setSessionProperty("nameId", (Object)tmp.getAttribute("value"));
                continue;
            }
            if (!"idpEntityId".equals(tmp.getLocalName())) continue;
            message.setSessionProperty("idpEntityId", (Object)tmp.getAttribute("value"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncomingRequest(SoapMessage message, SOAPMessageContext context, ThreadLocal<Subject> cred, Subject subject, Map<Object, Object> sharedMap) {
        logger.debug("Incomming Request : " + this.requestHandler.print((Node)context.getMessage().getSOAPPart()), new Object[0]);
        try {
            this.requestHandler.validateRequest(context.getMessage(), subject, sharedMap, null, null);
            WsHandler wsHandler = this;
            synchronized (wsHandler) {
                cred.set(subject);
            }
            message.setContent(XMLStreamReader.class, (Object)this.getSOAPReader(context));
        }
        catch (Exception ex) {
            logger.error((Throwable)ex, "validateRequest failed.", new Object[0]);
            throw new ProtocolException((Throwable)ex);
        }
    }

    private void handleOutgoingResponse(SoapMessage message, SOAPMessageContext context, ThreadLocal<Subject> cred, Subject subject, Map<Object, Object> sharedMap) {
        logger.debug("Outgoing Response : " + this.requestHandler.print((Node)context.getMessage().getSOAPPart()), new Object[0]);
        try {
            this.requestHandler.secureResponse(context.getMessage(), sharedMap);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex, "secureResponse failed.", new Object[0]);
            throw new ProtocolException((Throwable)ex);
        }
    }
}

