/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.authz;

import java.io.UnsupportedEncodingException;
import jp.co.ogis_ri.citk.authz.common.AuthzUtil;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.interceptor.Interceptor;
import org.mule.processor.AbstractInterceptingMessageProcessor;

public class AuthzInterceptor
extends AbstractInterceptingMessageProcessor
implements Interceptor {
    private static final CitkLogger logger = CitkLogger.getLog(AuthzInterceptor.class);
    private static final CitkLogger opLogger = CitkLogger.getOperationLog();
    private String authzUrl;
    private String spEntityId;

    public void setAuthzUrl(String authzUrl) {
        this.authzUrl = authzUrl;
    }

    public void setSpEntityId(String spEntityId) {
        this.spEntityId = spEntityId;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleMessage message = event.getMessage();
        String messageID = message.getUniqueId();
        try {
            String url = this.createUrl(event);
            String decision = AuthzUtil.getDecisionForFedlet(url);
            opLogger.info("I-0202", new Object[]{messageID, decision});
            if (!"Permit".equals(decision)) {
                throw new DefaultMuleException("This request is not permitted.");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DefaultMuleException((Throwable)e);
        }
        return event;
    }

    private String createUrl(MuleEvent event) throws UnsupportedEncodingException {
        MuleMessage message = event.getMessage();
        String method = (String)message.getInboundProperty("http.method");
        String nameId = (String)message.getSessionProperty("nameId");
        String idpEntityId = (String)message.getSessionProperty("idpEntityId");
        String resource = event.getMessageSourceURI().toString();
        opLogger.info("I-0201", new Object[]{message.getUniqueId(), idpEntityId, method, nameId, resource});
        return AuthzUtil.createFedletUrl(this.authzUrl, this.spEntityId, method, idpEntityId, nameId, resource);
    }
}

