/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.authn.transformer.http;

import java.util.Date;
import java.util.TimeZone;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import org.apache.commons.httpclient.Cookie;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.transformer.AbstractMessageTransformer;

public class AuthnSetCookiesTransformer
extends AbstractMessageTransformer {
    private static final CitkLogger logger = CitkLogger.getLog(AuthnSetCookiesTransformer.class);
    private String timezone = null;
    private long expire = 0L;
    private String domain = null;

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public MuleMessage transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        TimeZone.setDefault(TimeZone.getTimeZone(this.timezone));
        Date expireDate = this.getExpireDate();
        String nameId = (String)message.getSessionProperty("nameId");
        String idpEntityId = (String)message.getSessionProperty("idpEntityId");
        String expireString = "" + expireDate.getTime();
        String accessDate = "" + this.getNowTime().getTime();
        Cookie[] cookies = new Cookie[]{this.createCookie(this.domain, "nameId", nameId, null), this.createCookie(this.domain, "idpEntityId", idpEntityId, null), this.createCookie(this.domain, "expire", expireString, null), this.createCookie(this.domain, "accessDate", accessDate, null)};
        message.setProperty("Set-Cookie", (Object)cookies, PropertyScope.INBOUND);
        if (logger.isDebugEnabled()) {
            for (Cookie cookie : cookies) {
                logger.debug("COOKIE: " + cookie.toString(), new Object[0]);
            }
        }
        return message;
    }

    private Date getExpireDate() {
        Date date = this.getNowTime();
        Date expireDate = this.expire == 0L ? new Date(this.expire) : new Date(date.getTime() + this.expire);
        return expireDate;
    }

    private Date getNowTime() {
        return new Date();
    }

    private Cookie createCookie(String domain, String cookieName, String value, Date expires) {
        return new Cookie(domain, cookieName, value, "/", expires, false);
    }
}

