/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.authn.transformer.http;

import java.util.UUID;
import jp.co.ogis_ri.citk.authn.transformer.http.RedirectionTransformer;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.common.util.RequestParameterCache;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;

public class RequestCacheTransformer
extends AbstractMessageTransformer {
    private static final CitkLogger logger = CitkLogger.getLog(RedirectionTransformer.class);
    private static final CitkLogger opLogger = CitkLogger.getOperationLog();
    private RequestParameterCache cache = null;

    public RequestParameterCache getCache() {
        return this.cache;
    }

    public void setCache(RequestParameterCache cache) {
        this.cache = cache;
    }

    public MuleMessage transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        String messageID = message.getMessageRootId();
        String relayState = UUID.randomUUID().toString();
        message.setSessionProperty("citk.relaystate", (Object)relayState);
        this.cache.add(relayState, (Object)message);
        logger.debug("messageID={0} relayState={1}", new Object[]{messageID, relayState});
        opLogger.info("I-0104", new Object[]{messageID, relayState});
        return message;
    }
}

