/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.authn.transformer.saml2;

import jp.co.ogis_ri.citk.common.exception.CitkSystemException;
import jp.co.ogis_ri.citk.common.exception.FedletException;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.common.util.ExceptionUtil;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.util.StringUtils;

public class SAML2InfoIntoMuleMessage
extends AbstractMessageTransformer {
    private static final CitkLogger logger = CitkLogger.getLog(SAML2InfoIntoMuleMessage.class);
    private static final CitkLogger opLogger = CitkLogger.getOperationLog();
    private static final String NAMEID_START_TAG = "<saml:NameID";
    private static final String NAMEID_END_TAG = "</saml:NameID>";
    private static final String NAMEID_NAMEQUALIFIER_TAG = "NameQualifier=\"";
    private String fedletURL = null;

    public String getFedletURL() {
        return this.fedletURL;
    }

    public void setFedletURL(String fedletURL) {
        this.fedletURL = fedletURL;
    }

    public SAML2InfoIntoMuleMessage() {
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.registerSourceType(DataTypeFactory.MULE_MESSAGE);
        this.setReturnDataType(DataTypeFactory.MULE_MESSAGE);
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        String messageID = message.getMessageRootId();
        String encode = message.getEncoding();
        String body = null;
        Object httpStatus = message.getInboundProperty("http.status");
        String contentType = (String)message.getInboundProperty("Content-Type");
        if (!httpStatus.equals("200") || !contentType.contains("text/html") || message.getPayload() instanceof NullPayload) {
            throw new CitkSystemException("\u30da\u30a4\u30ed\u30fc\u30c9\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", message);
        }
        try {
            body = message.getPayloadAsString(encode);
        }
        catch (Exception e) {
            logger.debug((Throwable)e);
            throw ExceptionUtil.convertRuntimeException((Throwable)e);
        }
        logger.debug("Fedlet\u30ec\u30b9\u30dd\u30f3\u30b9\uff1a{0}", new Object[]{body});
        String nameIdElement = this.getNameIdElement(body);
        if (nameIdElement == null) {
            throw new FedletException("E-0102", this.fedletURL, body, new Object[0]);
        }
        message.setOutboundProperty("http.status", httpStatus);
        String nameID = this.getNameId(nameIdElement);
        if (StringUtils.isEmpty((String)nameID)) {
            throw new FedletException("E-0103", this.fedletURL, body, new Object[0]);
        }
        String idpEntityId = this.getIdpEntityId(nameIdElement);
        if (StringUtils.isEmpty((String)idpEntityId)) {
            throw new FedletException("E-0104", this.fedletURL, body, new Object[0]);
        }
        String relayState = (String)message.getSessionProperty("citk.relaystate");
        message.setSessionProperty("nameId", (Object)nameID);
        message.setSessionProperty("idpEntityId", (Object)idpEntityId);
        opLogger.info("I-0105", new Object[]{messageID, relayState, nameID, idpEntityId});
        return message;
    }

    private String getNameId(String data) {
        String nameId = data.replaceAll(NAMEID_END_TAG, "");
        return nameId.replaceAll("<saml:NameID.*\\>", "");
    }

    private String getIdpEntityId(String data) {
        int sp = data.indexOf(NAMEID_NAMEQUALIFIER_TAG) + NAMEID_NAMEQUALIFIER_TAG.length();
        String tmp = data.substring(sp);
        String[] temps = tmp.split("\"");
        return temps[0];
    }

    private String getNameIdElement(String body) {
        String value = StringUtils.substringBetween((String)body, (String)NAMEID_START_TAG, (String)NAMEID_END_TAG);
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(NAMEID_START_TAG).append(value).append(NAMEID_END_TAG);
        return sb.toString();
    }
}

