/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.authn.transformer.http;

import java.util.UUID;

import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.log.CitkLogger;
import jp.co.ogis_ri.citk.common.util.RequestParameterCache;

import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;

/**
 * Mule ESBのリクエストメッセ時キャッシュ用トランスフォーマークラス。
 * 
 * @author ISP Shiraishi
 * 
 */
public class RequestCacheTransformer extends AbstractMessageTransformer {
    /**
     * ログメッセージ出力用ロガー。
     */
    private static final CitkLogger logger =
            CitkLogger.getLog(RedirectionTransformer.class);

    /**
     * 操作ログメッセージ出力用ロガー。
     */
    private static final CitkLogger opLogger = CitkLogger.getOperationLog();

    /**
     * リクエストMuleMessgaeを収めたキャッシュ。
     * 
     * @see RequestParameterCache
     */
    private RequestParameterCache cache = null;

    /**
     * リクエストMuleMessgaeを収めたキャッシュを取得する。
     * 
     * @return RequestParameterCache　リクエストMuleMessgaeを収めたキャッシュ。
     */
    public RequestParameterCache getCache() {
        return cache;
    }

    /**
     * リクエストMuleMessgaeを収めたキャッシュを設定する。
     * 
     * @param cache リクエストMuleMessgaeを収めたキャッシュ。
     */
    public void setCache(RequestParameterCache cache) {
        this.cache = cache;
    }

    /**
     * コンストラクタ.
     * 
     */
    public RequestCacheTransformer() {
        super();
    }

    /**
     * 認証前のリクエストパラメータをキャッシュに保持する。
     * 
     * @param message 変換対象のMuleメッセージ。
     * @param outputEncoding エンコード。
     * @return 変換後のMuleメッセージ。
     * @throws TransformerException。
     */
    @Override
    public MuleMessage transformMessage(MuleMessage message,
            String outputEncoding) throws TransformerException {
        String messageID = message.getMessageRootId();
        String relayState = UUID.randomUUID().toString();
        message.setSessionProperty(CitkConstants.CITK_RELAYSTATE_KEY,
                relayState);
        cache.add(relayState, message);
        logger.debug("messageID={0} relayState={1}", messageID, relayState);
        opLogger.info("I-0104", messageID, relayState);
        return message;
    }

}
