/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.authn.filter.saml2;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import jp.co.ogis_ri.citk.common.CitkConstants;

import org.apache.commons.httpclient.Cookie;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.http.HttpConnector;

public class AccessFilterTestCase extends AbstractMuleContextTestCase {

    private AccessFilter filter = new AccessFilter();
    private String nameID = "m//y2PWdQQL8MZAmE3ml9wTp0Cjy";
    private String nameID_value = "<saml:NameID Format=\"urn:oasis:names:tc:SAML:2.0:nameid-format:transient\" NameQualifier=\"citkidp\" SPNameQualifier=\"citksp\">m//y2PWdQQL8MZAmE3ml9wTp0Cjy</saml:NameID>";


    @Test
    public void testAccept_noCookies() throws Exception {
        MuleMessage message = new DefaultMuleMessage("OK", muleContext);
        RequestContext.setEvent(getTestEvent(message));

        assertFalse(filter.accept(message));
    }

    @Test
    public void testAccept_noIdpEntityIdCookie() throws Exception {
        MuleMessage message = new DefaultMuleMessage("OK", muleContext);
        RequestContext.setEvent(getTestEvent(message));

        Cookie[] cookies = new Cookie[3];
        Date date = new Date();
        cookies[0] = new Cookie(".citk202.com", CitkConstants.NAMEID_KEY,
                nameID, "/", date, false);
        cookies[1] = new Cookie(".citk202.com",
                CitkConstants.CITK_EXPIRE_COOKIE_NAME, "0", "/", date, false);
        cookies[2] = new Cookie(".citk202.com",
                CitkConstants.CITK_ACCESS_DATE_COOKIE_NAME,
                "" + date.getTime(), "/", date, false);

        message.setProperty(HttpConnector.HTTP_COOKIES_PROPERTY, cookies,
                PropertyScope.INBOUND);

        assertFalse(filter.accept(message));
    }

    @Test
    public void testAccept_noNameIDCookie() throws Exception {
        MuleMessage message = new DefaultMuleMessage("OK", muleContext);
        RequestContext.setEvent(getTestEvent(message));

        Cookie[] cookies = new Cookie[3];
        Date date = new Date();
        cookies[0] = new Cookie(".citk202.com", CitkConstants.IDP_ENTITYID_KEY,
                "idp202", "/", date, false);
        cookies[1] = new Cookie(".citk202.com",
                CitkConstants.CITK_EXPIRE_COOKIE_NAME, "0", "/", date, false);
        cookies[2] = new Cookie(".citk202.com",
                CitkConstants.CITK_ACCESS_DATE_COOKIE_NAME,
                "" + date.getTime(), "/", date, false);

        message.setProperty(HttpConnector.HTTP_COOKIES_PROPERTY, cookies,
                PropertyScope.INBOUND);

        assertFalse(filter.accept(message));

    }

    @Test
    public void testAccept_noExpireCookie() throws Exception {
        MuleMessage message = new DefaultMuleMessage("OK", muleContext);
        RequestContext.setEvent(getTestEvent(message));

        Cookie[] cookies = new Cookie[3];
        Date date = new Date();
        cookies[0] = new Cookie(".citk202.com", CitkConstants.NAMEID_KEY,
                nameID, "/", date, false);
        cookies[1] = new Cookie(".citk202.com", CitkConstants.IDP_ENTITYID_KEY,
                "idp202", "/", date, false);
        cookies[2] = new Cookie(".citk202.com",
                CitkConstants.CITK_ACCESS_DATE_COOKIE_NAME,
                "" + date.getTime(), "/", date, false);

        message.setProperty(HttpConnector.HTTP_COOKIES_PROPERTY, cookies,
                PropertyScope.INBOUND);

        assertFalse(filter.accept(message));

    }

    @Test
    public void testAccept_noAccessDateCookie() throws Exception {
        MuleMessage message = new DefaultMuleMessage("OK", muleContext);
        RequestContext.setEvent(getTestEvent(message));

        Cookie[] cookies = new Cookie[3];
        Date date = new Date();
        cookies[0] = new Cookie(".citk202.com", CitkConstants.NAMEID_KEY,
                nameID, "/", date, false);
        cookies[1] = new Cookie(".citk202.com", CitkConstants.IDP_ENTITYID_KEY,
                "idp202", "/", date, false);
        cookies[2] = new Cookie(".citk202.com",
                CitkConstants.CITK_EXPIRE_COOKIE_NAME, "0", "/", date, false);

        message.setProperty(HttpConnector.HTTP_COOKIES_PROPERTY, cookies,
                PropertyScope.INBOUND);

        assertFalse(filter.accept(message));

    }

    @Test
    public void testAccept_NoMatchIdp() throws Exception {
        MuleMessage message = new DefaultMuleMessage("OK", muleContext);
        RequestContext.setEvent(getTestEvent(message));

        Cookie[] cookies = new Cookie[4];
        Date date = new Date();
        cookies[0] = new Cookie(".citk202.com", CitkConstants.NAMEID_KEY,
                nameID, "/", date, false);
        cookies[1] = new Cookie(".citk202.com", CitkConstants.IDP_ENTITYID_KEY,
                "idp202", "/", date, false);
        cookies[2] = new Cookie(".citk202.com",
                CitkConstants.CITK_EXPIRE_COOKIE_NAME, "0", "/", date, false);
        cookies[3] = new Cookie(".citk202.com",
                CitkConstants.CITK_ACCESS_DATE_COOKIE_NAME,
                "" + date.getTime(), "/", date, false);

        message.setProperty(HttpConnector.HTTP_COOKIES_PROPERTY, cookies,
                PropertyScope.INBOUND);

        message.setProperty(CitkConstants.IDP_ENTITYID_KEY, "idp201",
                PropertyScope.INBOUND);

        assertFalse(filter.accept(message));

    }

    @Test
    public void testAccept() throws Exception {
        MuleMessage message = new DefaultMuleMessage("OK", muleContext);
        RequestContext.setEvent(getTestEvent(message));

        Cookie[] cookies = new Cookie[4];
        Date date = new Date();
        cookies[0] = new Cookie(".citk202.com", CitkConstants.NAMEID_KEY,
                nameID, "/", date, false);
        cookies[1] = new Cookie(".citk202.com", CitkConstants.IDP_ENTITYID_KEY,
                "idp202", "/", date, false);
        cookies[2] = new Cookie(".citk202.com",
                CitkConstants.CITK_EXPIRE_COOKIE_NAME, "0", "/", date, false);
        cookies[3] = new Cookie(".citk202.com",
                CitkConstants.CITK_ACCESS_DATE_COOKIE_NAME,
                "" + date.getTime(), "/", date, false);

        message.setProperty(HttpConnector.HTTP_COOKIES_PROPERTY, cookies,
                PropertyScope.INBOUND);

        assertTrue(filter.accept(message));

        String expectedNameId = nameID.replaceAll("/", "%2F");
        String resultNameId = message
                .getSessionProperty(CitkConstants.NAMEID_KEY);

        assertEquals(expectedNameId, resultNameId);
    }

}
