/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.authn.transformer.http;

import static org.junit.Assert.assertEquals;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.util.RequestParameterCache;
import mockit.Deencapsulation;

import org.apache.commons.httpclient.Cookie;
import org.apache.tomcat.util.http.Cookies;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.PropertyScope;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpConstants;

public class RedirectionTransformerTestCase_ACS_NG extends
        AbstractMuleContextTestCase {
    private static String encoding = "UTF-8";
    private static String requestPath = "/sp1/app/test/test.html";
    private static String cachePath = "/sp1/test/test.html";
    private static final String PAYLOAD = "http body!";
    private static final String location = "http://redirect.com";
    private static Map<String, Object> requestMessageProperties;
    private static Map<String, Object> cacheMessageProperties;

    private static RequestParameterCache cache;
    private static MuleMessage cacheMessage;
    private static String relayState = "abcd1234";
    private static String domain = ".citk202.com";
    static {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put(HttpConnector.HTTP_METHOD_PROPERTY, "GET");
        map.put(HttpConstants.HEADER_ACCEPT,
                "text/html, application/xhtml+xml, */*");
        map.put(HttpConstants.HEADER_ACCEPT_LANGUAGE, "ja,en-US;q=0.8,en;q=0.6");
        map.put(HttpConstants.HEADER_CONNECTION, "Keep-Alive");
        map.put(HttpConstants.HEADER_HOST, "www.acme.com");
        map.put(HttpConnector.HTTP_CONTEXT_PATH_PROPERTY, "/");
        map.put(HttpConnector.HTTP_REQUEST_PROPERTY, requestPath
                + "?RelayState=" + relayState);
        map.put(CitkConstants.RELAYSTATE_PARAM, relayState);
        map.put(HttpConnector.HTTP_REQUEST_PATH_PROPERTY, requestPath);
        map.put(HttpConnector.HTTP_VERSION_PROPERTY, HttpConstants.HTTP11);
        map.put(HttpConstants.HEADER_LOCATION, location);
        requestMessageProperties = Collections.unmodifiableMap(map);

        Map<String, Object> map2 = new HashMap<String, Object>();
        map2.put(HttpConnector.HTTP_METHOD_PROPERTY, "POST");
        map2.put(HttpConstants.HEADER_ACCEPT,
                "text/html, application/xhtml+xml, */*");
        map2.put(HttpConstants.HEADER_ACCEPT_LANGUAGE,
                "ja,en-US;q=0.8,en;q=0.6");
        map2.put(HttpConstants.HEADER_CONNECTION, "Keep-Alive");
        map2.put(HttpConstants.HEADER_HOST, "www.abcd.com");
        map2.put(HttpConnector.HTTP_CONTEXT_PATH_PROPERTY, "/");
        map2.put(HttpConnector.HTTP_REQUEST_PROPERTY, cachePath + "?"
                + CitkConstants.IDP_ENTITYID_KEY + "=idp202");
        map2.put(HttpConnector.HTTP_REQUEST_PATH_PROPERTY, cachePath);
        map2.put(HttpConnector.HTTP_VERSION_PROPERTY, HttpConstants.HTTP11);

        cacheMessageProperties = Collections.unmodifiableMap(map2);

    }

    // setup 時に呼ばれるメソッド。親クラスのテンプレートメソッドをオーバーライドした。
    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        // トランスフォーマのテストをする際は、必ずRequestContextのイベントが設定されてなければならない。
        RequestContext.setEvent(getTestEvent("test"));
        cacheMessage =
                new DefaultMuleMessage(PAYLOAD, cacheMessageProperties, null,
                        null, muleContext);
        cache = Deencapsulation.newInstance(RequestParameterCache.class);

        Map<String, MuleMessage> cacheMap = new HashMap<String, MuleMessage>();
        cacheMap.put(relayState, cacheMessage);

        cache.setCache(cacheMap);
    }

    // tear down 時に呼ばれるメソッド。親クラスのテンプレートメソッドをオーバーライドした。
    @Override
    protected void doTearDown() throws Exception {
        super.doTearDown();
        // RequestContext の値をnullに戻し、次のテストメソッドに備える。
        RequestContext.setEvent(null);
    }

    public Transformer getTransformer() throws Exception {
        Transformer trans = createObject(RedirectionTransformer.class);
        trans.setReturnDataType(DataTypeFactory.create(MuleMessage.class));

        EndpointBuilder builder =
                new EndpointURIEndpointBuilder("test://test", muleContext);
        builder.setEncoding(encoding);
        ImmutableEndpoint endpoint =
                muleContext.getEndpointFactory().getInboundEndpoint(builder);
        trans.setEndpoint(endpoint);

        ((RedirectionTransformer) trans).setCache(cache);
        ((RedirectionTransformer) trans).setRequestProtocol("http://");
        ((RedirectionTransformer) trans).setDomain(domain);
        ((RedirectionTransformer) trans).setIdpAuthnCookieName("iPlanetDirectoryPro");
        return trans;
    }

    public Transformer getRoundTripTransformer() throws Exception {
        // skip test
        return null;
    }

    public Object getTestData() {
        MuleMessage mes =
                new DefaultMuleMessage(PAYLOAD, requestMessageProperties, null,
                        null, muleContext);

        mes.setOutboundProperty(CitkConstants.CITK_ACS_STATUS_KEY,
                CitkConstants.CITK_ACS_STATUS_NG);
        mes.setSessionProperty(CitkConstants.CITK_RELAYSTATE_KEY, relayState);

        return mes;
    }

    public Object getResultData() {
        MuleMessage mes =
                new DefaultMuleMessage(PAYLOAD, requestMessageProperties, null,
                        null, muleContext);

        mes.setOutboundProperty(HttpConnector.HTTP_STATUS_PROPERTY,
                HttpConstants.SC_MOVED_TEMPORARILY);
        String location =
                RedirectionTransformerTestCase_ACS_NG.location + "?"
                        + CitkConstants.RELAYSTATE_PARAM + "=" + relayState;
        mes.setOutboundProperty(HttpConstants.HEADER_LOCATION, location);

        Cookie[] cookies = new Cookie[4];
        Date deleteExpire = new Date(0);

        cookies[0] =
                new Cookie(domain, CitkConstants.NAMEID_KEY, "dumyData", "/",
                        deleteExpire, false);
        cookies[1] =
                new Cookie(domain, CitkConstants.IDP_ENTITYID_KEY, "dumyData",
                        "/", deleteExpire, false);
        cookies[2] =
                new Cookie(domain, CitkConstants.CITK_EXPIRE_COOKIE_NAME,
                        "dumyData", "/", deleteExpire, false);
        cookies[3] =
                new Cookie(domain, CitkConstants.CITK_ACCESS_DATE_COOKIE_NAME,
                        "dumyData", "/", deleteExpire, false);

        mes.setProperty(HttpConstants.HEADER_COOKIE_SET, cookies,
                PropertyScope.INBOUND);

        return mes;
    }

    @Test
    public void testTransform() throws Exception {
        Transformer trans = this.getTransformer();
        Object result = trans.transform(getTestData());
        Object expectedResult = this.getResultData();

        MuleMessage expectedMessage = (MuleMessage) expectedResult;
        MuleMessage resultMessage = (MuleMessage) result;

        Integer expectedStatus =
                expectedMessage.getOutboundProperty(HttpConnector.HTTP_STATUS_PROPERTY);
        Integer resultStatus =
                resultMessage.getOutboundProperty(HttpConnector.HTTP_STATUS_PROPERTY);

        assertEquals(expectedStatus, resultStatus);

        String expectedLocation =
                expectedMessage.getOutboundProperty(HttpConstants.HEADER_LOCATION);
        String resultLocation =
                resultMessage.getOutboundProperty(HttpConstants.HEADER_LOCATION);

        assertEquals(expectedLocation, resultLocation);

        Cookie[] expectedCookies =
                expectedMessage.getInboundProperty(HttpConstants.HEADER_COOKIE_SET);
        Cookie[] resultCookies =
                resultMessage.getInboundProperty(HttpConstants.HEADER_COOKIE_SET);

        for (int i = 0; i < 4; i++) {
            assertEquals(expectedCookies[i], resultCookies[i]);
        }
    }

}
