/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.authn.transformer.http;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;
import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.util.RequestParameterCache;
import mockit.Deencapsulation;
import mockit.Expectations;

import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.types.DataTypeFactory;

public class RequestCacheTransformerTestCase extends
        AbstractMuleContextTestCase {
    private static final String encoding = "UTF-8";
    private static final String relayState =
            "8a041209-b359-4789-9e7b-fa5d578dbd3f";

    private static RequestParameterCache cache;

    public MuleMessage message;

    // setup 時に呼ばれるメソッド。親クラスのテンプレートメソッドをオーバーライドした。
    @Override
    public void doSetUp() throws Exception {
        super.doSetUp();
        // トランスフォーマのテストをする際は、必ずRequestContextのイベントが設定されてなければならない。
        RequestContext.setEvent(getTestEvent("test"));

        message = new DefaultMuleMessage("test1", muleContext);
    }

    // tear down 時に呼ばれるメソッド。親クラスのテンプレートメソッドをオーバーライドした。
    @Override
    protected void doTearDown() throws Exception {
        super.doTearDown();
        // RequestContext の値をnullに戻し、次のテストメソッドに備える。
        RequestContext.setEvent(null);
    }

    public Transformer getTransformer() throws Exception {
        final Transformer trans = createObject(RequestCacheTransformer.class);

        new Expectations(trans) {
            {
                invoke(trans, "toString");
                returns(relayState);
            }
        };

        trans.setReturnDataType(DataTypeFactory.create(MuleMessage.class));

        EndpointBuilder builder =
                new EndpointURIEndpointBuilder("test://test", muleContext);
        builder.setEncoding(encoding);
        ImmutableEndpoint endpoint =
                muleContext.getEndpointFactory().getInboundEndpoint(builder);
        trans.setEndpoint(endpoint);
        cache = Deencapsulation.newInstance(RequestParameterCache.class);

        ((RequestCacheTransformer) trans).setCache(cache);
        return trans;
    }

    public Object getTestData() {

        return message;
    }

    public Object getResultData() {

        message.setSessionProperty(CitkConstants.CITK_RELAYSTATE_KEY,
                relayState);
        return message;
    }

    @Test
    public void testTransform() throws Exception {
        Transformer trans = this.getTransformer();
        Object result = trans.transform(getTestData());
        Object expectedResult = this.getResultData();

        MuleMessage expectedMessage = (MuleMessage) expectedResult;
        MuleMessage resultMessage = (MuleMessage) result;

        String expectedRelayState =
                expectedMessage.getSessionProperty(CitkConstants.CITK_RELAYSTATE_KEY);
        String resultRelayState =
                resultMessage.getSessionProperty(CitkConstants.CITK_RELAYSTATE_KEY);

        assertEquals(expectedRelayState, resultRelayState);

        RequestParameterCache resultCache =
                ((RequestCacheTransformer) trans).getCache();
        assertSame(cache, resultCache);
    }

}
