/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.authz;

import static jp.co.ogis_ri.citk.authz.common.AuthzUtil.createFedletUrl;
import static jp.co.ogis_ri.citk.authz.common.AuthzUtil.getDecisionForFedlet;
import static jp.co.ogis_ri.citk.common.CitkConstants.IDP_ENTITYID_KEY;
import static jp.co.ogis_ri.citk.common.CitkConstants.NAMEID_KEY;
import static jp.co.ogis_ri.citk.common.CitkConstants.AUTHZ_PERMIT;
import static org.mule.transport.http.HttpConnector.HTTP_METHOD_PROPERTY;

import java.io.UnsupportedEncodingException;

import jp.co.ogis_ri.citk.common.log.CitkLogger;

import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.interceptor.Interceptor;
import org.mule.processor.AbstractInterceptingMessageProcessor;

/**
 * 認可時のインターセプタ。
 *
 */
public class AuthzInterceptor extends AbstractInterceptingMessageProcessor
        implements Interceptor {

    /**
     * ログメッセージ出力用オブジェクト。
     */
    private static final CitkLogger logger =
            CitkLogger.getLog(AuthzInterceptor.class);

    /**
     * 操作ログメッセージ出力用ロガー。
     */
    private static final CitkLogger opLogger = CitkLogger.getOperationLog();

    /**
     * PEPのURLを設定する。
     */
    private String authzUrl;

    /**
     * 認可時のSPのエンティティID。
     */
    private String spEntityId;

    /**
     * PEPのURLを設定する。
     * 
     * @param authzUrl PEPのURL。
     * 
     */
    public void setAuthzUrl(String authzUrl) {
        this.authzUrl = authzUrl;
    }

    /**
     * 認可時のSPのエンティティIDを設定する。
     * 
     * @param spEntityId SPのエンティティID。
     */
    public void setSpEntityId(String spEntityId) {
        this.spEntityId = spEntityId;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {

        MuleMessage message = event.getMessage();
        String messageID = message.getUniqueId();

        try {
            String url = createUrl(event);

            String decision = getDecisionForFedlet(url);
            opLogger.info("I-0202", messageID, decision);

            if (!AUTHZ_PERMIT.equals(decision)) {
                throw new DefaultMuleException("This request is not permitted.");
            }

        } catch (UnsupportedEncodingException e) {
            throw new DefaultMuleException(e);
        }

        return event;
    }

    private String createUrl(MuleEvent event)
            throws UnsupportedEncodingException {

        MuleMessage message = event.getMessage();
        String method = message.getInboundProperty(HTTP_METHOD_PROPERTY);
        String nameId = message.getSessionProperty(NAMEID_KEY);
        String idpEntityId = message.getSessionProperty(IDP_ENTITYID_KEY);
        String resource = event.getMessageSourceURI().toString();

        opLogger.info("I-0201", message.getUniqueId(), idpEntityId, method,
                nameId, resource);

        return createFedletUrl(authzUrl, spEntityId, method, idpEntityId,
                nameId, resource);
    }
}
