/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common;

/**
 * CITKの共通Constantsクラス。
 * 
 * @author ISP Shiraishi
 * 
 */
public class CitkConstants {
    /**
     * NAME ID。
     */
    public static final String NAMEID_KEY = "nameId";

    /**
     * 認可リクエストパラメータ。
     */
    public static final String AUTHZ_REQUEST_PARAM = "authz";

    /**
     * IdP エンティティIDのキー。
     */
    public static final String IDP_ENTITYID_KEY = "idpEntityId";

    /**
     * CITKのネームスペース。
     */
    public static final String CITK_NS = "citknamespace";

    /**
     * CITKのプリフィックス。
     */
    public static final String CITK_PREFIX = "citk";

    /**
     * CITKのローカル名。
     */
    public static final String CITK_LOCALNAME = "cred";

    /**
     * MuleMessage内のRelay Stateのキー。
     */
    public static final String CITK_RELAYSTATE_KEY = "citk.relaystate";

    /**
     * MuleMessage内のACSステータスのキー。
     */
    public static final String CITK_ACS_STATUS_KEY = "citk.acs.status";

    /**
     * ACSステータスの値(OK)。
     */
    public static final String CITK_ACS_STATUS_OK = "ok";

    /**
     * ACSステータスの値(NG)。
     */
    public static final String CITK_ACS_STATUS_NG = "ng";
    
    /**
     * MuleMessage内のタイムアウト状態を示すキー。
     */
    public static final String CITK_ISTIMEOUT_KEY = "citk.isTimeOut";
    
    /**
     * Relay Stateのパラメータ名。
     */
    public static final String RELAYSTATE_PARAM = "RelayState";

    /**
     * expireのCookie名。
     */
    public static final String CITK_EXPIRE_COOKIE_NAME = "expire";

    /**
     * accessDateのCookie名。
     */
    public static final String CITK_ACCESS_DATE_COOKIE_NAME = "accessDate";

    /**
     * MuleMessage内の認可結果のキー。
     */
    public static final String AUTHZ_RESULT_KEY = "authz.result";

    /**
     * 認可結果結果(許可)。
     */
    public static final String AUTHZ_PERMIT = "Permit";

    /**
     * 認可結果結果(拒否)。
     */
    public static final String AUTHZ_DENY = "Deny";

    /**
     * 認可結果結果(未定義)。
     */
    public static final String AUTHZ_INDETERMINATE = "Indeterminate";

    /**
     * MuleMessage内のアドレスのキー。
     */
    public static final String OUTBOUND_ADDRESS = "outBound.address";

    /**
     * MuleMessage内のプロトコルのキー。
     */
    public static final String OUTBOUND_PROTOCOL = "outBound.protocol";

    /**
     * ログメッセージのリソースバンドル名。
     */
    public static final String LOG_MESSAGE_PROPERTIES = "citk-log-messages";

    /**
     * ログメッセージのリソースバンドル名。
     */
    public static final String ERROR_MESSAGE_PROPERTIES =
            "citk-exception-messages";

    /**
     * システム例外:ACSステータス不正のメッセージ。
     */
    public static final String ERROR_MSG_INVALID_ACSSTATUS =
            "acsStatusに不正な値が含まれています";

    /**
     * システム例外:リダイレクト先のロケーション不正のメッセージ。
     */
    public static final String ERROR_MSG_LOCATION_IS_NULL =
            "リダイレクト先LocationがNULLです";

    /**
     * システム例外:ペイロード取得エラーのメッセージ。
     */
    public static final String ERROR_MSG_NOT_CONTAIN_PAYLOARD =
            "ペイロードの取得に失敗しました";
    
    /**
     * システム例外:認可結果取得エラーのメッセージ。
     */
    public static final String ERROR_MSG_AUTHORIZE_FAILUER = "認可結果が取得できません";
}
