/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.exception;

import jp.co.ogis_ri.citk.common.resource.CitkErrorMessageResource;

/**
 * CitkApplicationExceptionクラス。
 * 
 * @author ISP Shiraishi
 */
public class CitkApplicationException extends RuntimeException {

    /**
	 * シリアルバージョンUID。
	 */
    private static final long serialVersionUID = 1L;

    /**
     * エラーメッセージリソースのインスタンス。
     * 
     */
    private static CitkErrorMessageResource errorMapping =
            CitkErrorMessageResource.getInstance();

    /**
     * ログ表示用メッセージ。
     */
    private String message = null;

    /**
     * コンストラクタ。
     * 
     * @param cause 原因例外。
     * @param errorCode エラーコード。
     * @param args 引数。
     */
    public CitkApplicationException(Throwable cause, String errorCode,
            Object... args) {
        super(errorCode, cause);

        message =
                "[" + errorCode + "]"
                        + errorMapping.getErrorMessage(errorCode, args);
    }

    /**
     * コンストラクタ。
     * 
     * @param errorCode エラーコード。
     * @param args 引数。
     */
    public CitkApplicationException(String errorCode, Object... args) {
        super(errorCode);

        message =
                "[" + errorCode + "]"
                        + errorMapping.getErrorMessage(errorCode, args);
    }

    @Override
    public String getMessage() {
        return message;
    }

}
