/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.exception;

import org.mule.api.MuleMessage;

/**
 * CitkSystemExceptionクラス。
 * 
 * @author ISP Shiraishi
 */
public class CitkSystemException extends RuntimeException {

    /**
	 * シリアルバージョンUID。
	 */
    private static final long serialVersionUID = 1L;

    /**
     * ログメッセージ用Muleメッセージ。
     */
    private MuleMessage muleMessage = null;

    /**
     * @param message メッセージ。
     */
    public CitkSystemException(Throwable cause) {
        super(cause);
    }

    /**
     * @param message メッセージ。
     */
    public CitkSystemException(String message) {
        super(message);
    }

    /**
     * コンストラクタ。
     * 
     * @param message メッセージ。
     * @param cause 原因例外。
     */
    public CitkSystemException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * コンストラクタ。
     * 
     * @param cause 原因例外。
     * @param muleMessage Muleメッセージ。
     */
    public CitkSystemException(Throwable cause, MuleMessage muleMessage) {
        super(cause);
        this.muleMessage = muleMessage;
    }

    /**
     * コンストラクタ。
     * 
     * @param message メッセージ。
     * @param muleMessage Muleメッセージ。
     */
    public CitkSystemException(String message, MuleMessage muleMessage) {
        super(message);
        this.muleMessage = muleMessage;
    }

    /**
     * コンストラクタ。
     * 
     * @param message メッセージ。
     * @param cause 原因例外。
     * @param muleMessage Muleメッセージ。
     */
    public CitkSystemException(String message, Throwable cause,
            MuleMessage muleMessage) {
        super(message, cause);
        this.muleMessage = muleMessage;
    }

    /**
     * Muleメッセージを取得する。
     * 
     * @return MuleMessage Muleメッセージ。
     * 
     */
    public MuleMessage getMuleMessage() {
        return muleMessage;
    }

    @Override
    public String getMessage() {
        return super.getMessage()
                + (muleMessage == null ? "" : " Mule Message: "
                        + muleMessage.toString());
    }
}
