/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.exception;

/**
 * EndPointMappingExceptionクラス。
 * 
 * @author ISP Shiraishi
 */
public class EndPointMappingException extends CitkApplicationException {

    /**
	 * シリアルバージョンUID。
	 */
    private static final long serialVersionUID = 1L;

    /**
     * ターゲットキー。
     */
    private String key = null;
    
    /**
     * 認可結果。
     */
    private String decision = null;
    
    /**
     * NameID。
     */
    private String nameID = null;
 
    /**
     * コンストラクタ。
     * 
     * @param cause 原因例外。
     * @param errorCode エラーコード。
     * @param key ターゲットキー。
     * @param decision 認可結果。
     * @param nameID Name ID。
     * @param args 引数。
     */
    public EndPointMappingException(Throwable cause, String errorCode,
            String key, String decision, String nameID, Object... args) {
        super(cause, errorCode, args);
        this.key = key;
        this.decision = decision;
        this.nameID = nameID;
    }

    /**
     * コンストラクタ。
     * 
     * @param errorCode　エラーコード。
     * @param key ターゲットキー。
     * @param decision 認可結果。
     * @param nameID Name ID。
     * @param args 引数。
     */
    public EndPointMappingException(String errorCode, String key,
            String decision, String nameID, Object... args) {
        super(errorCode, args);
        this.key = key;
        this.decision = decision;
        this.nameID = nameID;
    }

    @Override
    public String getMessage() {
        String keyInfo = (key == null ? "" : " Key : " + key);
        String decisionInfo = (decision == null ? "" : ", Decision : "
                + decision);
        String nameIDInfo = (nameID == null ? "" : ", NameID : " + nameID);
        return super.getMessage() + keyInfo + decisionInfo + nameIDInfo;
    }
}
