/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.exception;

/**
 * FedletExceptionクラス。
 * 
 * @author ISP Shiraishi
 */
public class FedletException extends CitkApplicationException {

    /**
	 * シリアルバージョンUID。
	 */
    private static final long serialVersionUID = 1L;

    /**
     * Fedletリクエスト先URL。
     */
    private String fedletURL = null;
    
    /**
     * Fedletからのレスポンス。
     */
    private String fedletResponse = null;

    
    /**
     * コンストラクタ。
     * 
     * @param cause 原因例外。
     * @param errorCode エラーコード。
     * @param requestURL　リクエスト先URL。
     * @param payloard　ペイロード。
     * @param args 引数。
     */
    public FedletException(Throwable cause, String errorCode,
            String requestURL, String payloard, Object... args) {
        super(cause, errorCode, args);
        fedletURL = requestURL;
        fedletResponse = payloard;
    }

    
    /**
     * @param errorCode
     * @param requestURL
     * @param payloard
     * @param args
     */
    public FedletException(String errorCode, String requestURL,
            String payloard, Object... args) {
        super(errorCode, args);
        fedletURL = requestURL;
        fedletResponse = payloard;
    }

    @Override
    public String getMessage() {
        String urlInfo = (fedletURL == null ? "" : " Fedlet-URL : " + fedletURL);
        String responseInfo = (fedletResponse == null ? ""
                : " , Fedlet-Response : " + fedletResponse);
        return super.getMessage() + urlInfo + responseInfo;
    }
}
