/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.exception;

import org.mule.api.MuleMessage;

/**
 * IllegalRequestExceptionクラス。
 * 
 * @author ISP Shiraishi
 */
public class IllegalRequestException extends CitkApplicationException {

    /**
     * シリアルバージョンUID。
	 */
    private static final long serialVersionUID = 1L;

    /**
     * ログ表示用Muleメッセージ。
     */
    private MuleMessage muleMessage = null;

    /**
     * コンストラクタ.
     * 
     * @param cause 原因例外。
     * @param errorCode エラーコード。
     * @param muleMessage Muleメッセージ。
     * @param args 引数。
     */
    public IllegalRequestException(Throwable cause, String errorCode,
            MuleMessage muleMessage, Object... args) {
        super(cause, errorCode, args);
        this.muleMessage = muleMessage;
    }

    /**
     * コンストラクタ。
     * 
     * @param errorCode エラーコード。
     * @param muleMessage Muleメッセージ。
     * @param args 引数。
     */
    public IllegalRequestException(String errorCode, MuleMessage muleMessage,
            Object... args) {
        super(errorCode, args);
        this.muleMessage = muleMessage;
    }

    @Override
    public String getMessage() {
        return super.getMessage()
                + (muleMessage == null ? "" : " MuleMessage : "
                        + muleMessage.toString());
    }

    /**
     * レスポンスペイロード用メッセージ取得メソッド。
     * 
     * @return　ペイロード用メッセージ。
     * 
     */
    public String getMessageToPayloard() {
        return super.getMessage();
    }

}
