/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.resource;

import java.text.MessageFormat;
import java.util.ResourceBundle;

import jp.co.ogis_ri.citk.common.CitkConstants;

/**
 * CITKのErrorメッセージ・HttpStatus管理クラス。
 * 
 * @author ISP Shiraishi
 * 
 */
public class CitkErrorMessageResource {

    /**
     * このクラスのシングルトンオブジェクト。
     */
    private static CitkErrorMessageResource me = new CitkErrorMessageResource();

    /**
     * ErrorMessagePropertiesオブジェクト。
     */
    private ResourceBundle messageResource = null;

    /**
     * コンストラクタ。
     */
    private CitkErrorMessageResource() {

        // メッセージの読み込み
        messageResource = ResourceBundle
                .getBundle(CitkConstants.ERROR_MESSAGE_PROPERTIES);

    }

    /**
     * エラーメッセージを取得する。
     * 
     * @param key エラーコード。
     * @return エラーメッセージ。
     */
    public String getErrorMessage(String key) {
        return messageResource.getString(key);
    }

    /**
     * エラーメッセージを取得する。
     * 
     * @param key エラーコード。
     * @param args 引数。
     * @return エラーメッセージ。
     */
    public String getErrorMessage(String key, Object... args) {
        String m = getErrorMessage(key);
        if (m == null) {
            return "";
        }

        return MessageFormat.format(m, args);
    }

    /**
     * このオブジェクトのシングルトンインスタンスを取得する。
     * 
     * @return CitkErrorMappingオブジェクト。
     */
    public static CitkErrorMessageResource getInstance() {
        return me;
    }

}
