/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.transformer.http;

import java.util.Collection;

import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transport.http.HttpConstants;

/**
 * Mule ESBのMuleMessageコピー用トランスフォーマークラス。
 * 
 * @author toyota
 * 
 */
public class CopyMessagePropertiesTransformer extends
        AbstractMessageTransformer {

    /**
     * インバウンドのプロパティをあうとバウンドへコピーする。
     * 
     * @param message 変換対象のMuleメッセージ。
     * @param outputEncoding エンコード。
     * @return 変換後のMuleメッセージ。
     * @throws TransformerException。
     */
    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding)
            throws TransformerException {
        Collection<String> requestHeaders = message.getInboundPropertyNames();
        Object inboundValue = null;

        for (String name : requestHeaders) {
            inboundValue = message.getInboundProperty(name);
            if (inboundValue != null) {
                if (String.class.equals(inboundValue.getClass())) {
                    if (!((String) inboundValue)
                            .equalsIgnoreCase(HttpConstants.HEADER_ACCEPT_ENCODING)) {
                        // TODO: support gzip encoding by
                        // using gzip-compress-transformer
                        // and gzip-uncompress-transformer
                        message.setOutboundProperty(name, inboundValue);
                    }
                } else {
                    message.setOutboundProperty(name, inboundValue);
                }
            }
        }

        return message;
    }
}
