/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.transformer.http;

import jp.co.ogis_ri.citk.common.exception.CitkSystemException;
import jp.co.ogis_ri.citk.common.exception.FedletException;
import jp.co.ogis_ri.citk.common.exception.IllegalRequestException;

import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpConstants;

/**
 * Mule ESBのカスタムトランスフォーマークラス。
 * 
 */
public class FedletErrorTransformer extends AbstractMessageTransformer {

    /**
     * FedletがErrorCodeを返却した際、ＣｉｔｋＥｘｃｅｐｔｉｏｎを発生させる。
     * 
     * @param message 変換対象のMuleメッセージ。
     * @param outputEncoding エンコード。
     * @return 変換後のMuleメッセージ。
     * @throws TransformerException。
     */
    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding)
            throws TransformerException {
        String payloard;
        try {
            payloard = message.getPayloadAsString();
        } catch (Exception e) {
            throw new CitkSystemException(e, message);
        }
        String status = message
                .getInboundProperty(HttpConnector.HTTP_STATUS_PROPERTY);

        if (status.equals("" + HttpConstants.SC_BAD_REQUEST)) {
            throw new IllegalRequestException(
                    "E-0001", message); // 不正なIdpEntityID
        } else {
            String URL = message
                    .getInboundProperty(HttpConnector.HTTP_REQUEST_PROPERTY);
            throw new FedletException(
                    "E-0101", URL,
                    payloard);// Fedletから応答無し
        }
    }

}
