/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.util;

import java.lang.reflect.InvocationTargetException;

import jp.co.ogis_ri.citk.common.exception.CitkSystemException;

/**
 * チェック例外変換ユーティリティ。
 */
public class ExceptionUtil {

    /**
     * コンストラクタ。
     */
    private ExceptionUtil() {
    }

    /**
     * すべての例外を適切な非チェック例外に変換する。
     * 
     * @param t 変換対象の例外。
     * @return 変換後の非チェック例外。
     */
    public static RuntimeException convertRuntimeException(Throwable t) {

        if (t instanceof Error) {
            throw Error.class.cast(t);
        }
        if (t instanceof RuntimeException) {
            return RuntimeException.class.cast(t);
        }
        if (t instanceof InvocationTargetException) {
            return convertRuntimeException(t.getCause());
        }
        return new CitkSystemException(t, null);
    }

}
