/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.exception;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;

public class CitkApplicationExceptionTestCase {

    @Test(expected = CitkApplicationException.class)
    public void testCitkApplicationExceptionStringThrowableObjectArray() {
        try {
            throw new CitkApplicationException(new NullPointerException(),
                    "E-0002", "aaabbbccc");
        } catch (CitkApplicationException e) {
            // success
            assertEquals(NullPointerException.class, e.getCause().getClass());
            assertEquals(e.getMessage(),
                    "[E-0002]RelayStateが不正です。リクエストメッセージキャッシュが取得できません.");
            throw e;
        }
    }

    @Test(expected = CitkApplicationException.class)
    public void testCitkApplicationExceptionStringObjectArray() {
        try {
            throw new CitkApplicationException("E-0002", "aaabbbccc");
        } catch (CitkApplicationException e) {
            // success
            assertNull(e.getCause());
            assertEquals(e.getMessage(),
                    "[E-0002]RelayStateが不正です。リクエストメッセージキャッシュが取得できません.");
            throw e;
        }
    }

    @Test
    public void testGetMessage() {
        CitkApplicationException target =
                new CitkApplicationException("E-0002");
        assertEquals(target.getMessage(),
                "[E-0002]RelayStateが不正です。リクエストメッセージキャッシュが取得できません.");
    }

}
