/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.exception;

import static org.junit.Assert.assertEquals;

import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class CitkSystemExceptionTestCase extends AbstractMuleContextTestCase {

    @Test(expected = CitkSystemException.class)
    public void testCitkSystemExceptionStringThrowable() {
        try {
            throw new CitkSystemException(new NullPointerException());
        } catch (CitkSystemException e) {
            // success
            assertEquals(NullPointerException.class, e.getCause().getClass());
            throw e;
        }
    }

    @Test(expected = CitkSystemException.class)
    public void testCitkSystemExceptionStringMuleMessage() {
        MuleMessage message = new DefaultMuleMessage("test1", muleContext);

        try {
            throw new CitkSystemException("認可処理に失敗しました", message);
        } catch (CitkSystemException e) {
            // success
            assertEquals(
                    "認可処理に失敗しました" + " Mule Message: " + message.toString(),
                    e.getMessage());
            throw e;
        }
    }

    @Test(expected = CitkSystemException.class)
    public void testCitkSystemExceptionStringNULLMuleMessage() {
        MuleMessage message = null;

        try {
            throw new CitkSystemException("認可処理に失敗しました", message);
        } catch (CitkSystemException e) {
            // success
            assertEquals("認可処理に失敗しました", e.getMessage());
            throw e;
        }
    }

    @Test(expected = CitkSystemException.class)
    public void testCitkSystemExceptionStringThrowableMuleMessage() {
        MuleMessage message = new DefaultMuleMessage("test1", muleContext);

        try {
            throw new CitkSystemException("認可処理に失敗しました",
                    new NullPointerException(), message);
        } catch (CitkSystemException e) {
            // success
            assertEquals(
                    "認可処理に失敗しました" + " Mule Message: " + message.toString(),
                    e.getMessage());
            assertEquals(NullPointerException.class, e.getCause().getClass());
            throw e;
        }
    }

}
