/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.exception;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;

public class EndPointMappingExceptionTestCase {

    private static final String testMessage =
            "[E-0002]RelayStateが不正です。リクエストメッセージキャッシュが取得できません."
                    + " Key : idp101/app1" + ", Decision : Permit"
                    + ", NameID : testNameID";

    @Test(expected = EndPointMappingException.class)
    public void testEndPointMappingExceptionStringThrowableStringStringStringObjectArray() {
        try {
            throw new EndPointMappingException(new NullPointerException(),
                    "E-0002", "idp101/app1", "Permit", "testNameID",
                    "nameID=aaabbbccc");
        } catch (EndPointMappingException e) {
            // success
            assertEquals(NullPointerException.class, e.getCause().getClass());
            assertEquals(e.getMessage(), testMessage);
            throw e;
        }
    }

    @Test(expected = EndPointMappingException.class)
    public void testEndPointMappingExceptionStringStringStringStringObjectArray() {
        try {
            throw new EndPointMappingException("E-0002", "idp101/app1",
                    "Permit", "testNameID", "nameID=aaabbbccc");
        } catch (EndPointMappingException e) {
            // success
            assertNull(e.getCause());
            assertEquals(e.getMessage(), testMessage);
            throw e;
        }
    }

}
