/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.exception;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;

public class FedletExceptionTestCase {

    private static final String testMessage =
            "[E-0002]RelayStateが不正です。リクエストメッセージキャッシュが取得できません."
                    + " Fedlet-URL : http://dummyurl.com"
                    + " , Fedlet-Response : testPayloard";

    @Test(expected = FedletException.class)
    public void testFedletExceptionThrowableStringStringObjectArray() {
        try {
            throw new FedletException(new NullPointerException(), "E-0002",
                    "http://dummyurl.com", "testPayloard", "nameID=aaabbbccc");
        } catch (FedletException e) {
            // success
            assertEquals(NullPointerException.class, e.getCause().getClass());
            assertEquals(e.getMessage(), testMessage);
            throw e;
        }
    }

    @Test(expected = FedletException.class)
    public void testFedletExceptionStringObjectArray() {
        try {
            throw new FedletException("E-0002", "http://dummyurl.com",
                    "testPayloard", "nameID=aaabbbccc");
        } catch (FedletException e) {
            // success
            assertNull(e.getCause());
            assertEquals(e.getMessage(), testMessage);
            throw e;
        }
    }

}
