/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.exception;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class IllegalRequestExceptionTestCase extends
        AbstractMuleContextTestCase {

    private static final String testMessage =
            "[E-0002]RelayStateが不正です。リクエストメッセージキャッシュが取得できません.";

    @Test(expected = IllegalRequestException.class)
    public void testIllegalRequestExceptionStringThrowableObjectArray() {

        MuleMessage message = new DefaultMuleMessage("test1", muleContext);

        try {
            throw new IllegalRequestException(new NullPointerException(),
                    "E-0002", message, "nameID=aaabbbccc");
        } catch (IllegalRequestException e) {
            // success
            assertEquals(NullPointerException.class, e.getCause().getClass());
            assertEquals(e.getMessage(), testMessage + " MuleMessage : "
                    + message.toString());
            throw e;
        }
    }

    @Test(expected = IllegalRequestException.class)
    public void testIllegalRequestExceptionStringObjectArray() {

        MuleMessage message = new DefaultMuleMessage("test1", muleContext);

        try {
            throw new IllegalRequestException("E-0002", message,
                    "nameID=aaabbbccc");
        } catch (IllegalRequestException e) {
            // success
            assertNull(e.getCause());
            assertEquals(e.getMessage(), testMessage + " MuleMessage : "
                    + message.toString());
            throw e;
        }
    }

}
