/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.log;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.GregorianCalendar;

import jp.co.ogis_ri.citk.common.exception.CitkApplicationException;
import jp.co.ogis_ri.citk.common.exception.CitkSystemException;

import org.junit.Test;

public class CitkLoggerTestCase {

    public static final String MESSAGE_DUMP =
            "<html><head><title>OpenAM (Login)</title>"
                    + "<script language=\"JavaScript\">"
                    + "    var defaultBtn = 'Submit';"
                    + "    var elmCount = 0;"
                    + "    function defaultSubmit() {"
                    + "        LoginSubmit(defaultBtn);"
                    + "    }"
                    + "</script>"
                    + "<script type=\"text/javascript\"><!--// Empty script so IE5.0 Windows will draw table and button borders"
                    + "//-->" + "</script></head>" + "<body></body></html>";

    @Test
    public void testGetLogClass() {
        CitkLogger target = CitkLogger.getLog(CitkLoggerTestCase.class);
        assertEquals(CitkLogger.class, target.getClass());
        assertTrue(target.isFatalEnabled());
    }

    @Test
    public void testLog_UseMessageFormatPattern() {
        CitkLogger target = CitkLogger.getLog("[PLACE_HOLDER]");
        assertEquals(CitkLogger.class, target.getClass());
        target.info(" time : {1,time}, string : {0}.", "TEST_STRING",
                GregorianCalendar.getInstance().getTime());
    }

    @Test
    public void testLogDumpMessage() {
        CitkLogger target = CitkLogger.getLog("[MESSAGE_DUMP]");
        assertEquals(CitkLogger.class, target.getClass());
        target.info(MESSAGE_DUMP);
    }

    @Test
    public void testGetLogString() {
        CitkLogger target =
                CitkLogger.getLog("jp.co.ogis_ri.citk.common.log.CitkLoggerTestCase");
        assertEquals(CitkLogger.class, target.getClass());
    }

    @Test
    public void testGetOperationLog() {
        CitkLogger target = CitkLogger.getOperationLog();
        assertEquals(CitkLogger.class, target.getClass());
        assertTrue(target.isErrorEnabled());
        target.error(new CitkApplicationException("E-0002"));
    }

    @Test
    public void testLog() {
        CitkLogger target = CitkLogger.getLog(CitkLoggerTestCase.class);

        if (target.isDebugEnabled() || target.isErrorEnabled()
                || target.isFatalEnabled() || target.isInfoEnabled()
                || target.isTraceEnabled() || target.isWarnEnabled()) {
        } else {
            fail();
        }

        String testParam = "testParam";

        Exception e = new CitkSystemException("Test");

        target.trace("I-0101");
        target.trace("I-0101", testParam);
        target.trace(e);
        target.trace(e, "I-0101", testParam);

        target.debug("I-0101");
        target.debug("I-0101", testParam);
        target.debug(e);
        target.debug(e, "I-0101", testParam);

        target.warn("I-0101");
        target.warn("I-0101", testParam);
        target.warn(e);
        target.warn(e, "I-0101", testParam);

        target.info("I-0101");
        target.info("I-0101", testParam);
        target.info(e);
        target.info(e, "I-0101", testParam);

        target.error("I-0101");
        target.error("I-0101", testParam);
        target.error(e);
        target.error(e, "I-0101", testParam);

        target.fatal("I-0101");
        target.fatal("I-0101", testParam);
        target.fatal(e);
        target.fatal(e, "I-0101", testParam);

    }

}
