/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.resource;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertSame;

import org.junit.Test;

public class CitkErrorMessageResourceTestCase {

    private static String key = "E-0002";
    private static String messageValue =
            "RelayStateが不正です。リクエストメッセージキャッシュが取得できません.";

    @Test
    public void testGetErrorMessage() {
        CitkErrorMessageResource target =
                CitkErrorMessageResource.getInstance();

        String result = target.getErrorMessage(key);
        assertNotNull(result);
        assertEquals(messageValue, result);
    }

    @Test
    public void testGetInstance() {
        CitkErrorMessageResource target1 =
                CitkErrorMessageResource.getInstance();
        CitkErrorMessageResource target2 =
                CitkErrorMessageResource.getInstance();

        assertSame(target1, target2);
        assertEquals(target1.getErrorMessage(key), target2.getErrorMessage(key));
    }

}
