/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.transformer.http;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import jp.co.ogis_ri.citk.common.exception.FedletException;
import jp.co.ogis_ri.citk.common.exception.IllegalRequestException;

import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.http.HttpConnector;

public class FedletErrorTransformerTestCase extends AbstractMuleContextTestCase {

    private static String encoding = "UTF-8";
    private static String url =
            "http://sp.citk202.com:9080/fedlet/saml2/jsp/fedletSSOInit.jsp?metaAlias=/sp&idpEntityID=idp20&binding=urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private static String TEST_PAYLOAD = "TEST PAYLOARD";
    private static String RESULT_PAYLOAD_500 =
            "[E-0101]SAMLリクエストの生成に失敗しました Fedlet-URL : " + url
                    + " , Fedlet-Response : " + TEST_PAYLOAD;
    private static String RESULT_PAYLOAD_400 =
            "[E-0001]指定したIdpEntityが不正です。 MuleMessage : ";
    private static Map<String, Object> messageProperties_400;
    private static Map<String, Object> messageProperties_500;

    static {
        Map<String, Object> map_400 = new HashMap<String, Object>();
        map_400.put(HttpConnector.HTTP_REQUEST_PROPERTY, url);
        map_400.put(HttpConnector.HTTP_STATUS_PROPERTY, "400");

        messageProperties_400 = Collections.unmodifiableMap(map_400);

        Map<String, Object> map_500 = new HashMap<String, Object>();
        map_500.put(HttpConnector.HTTP_REQUEST_PROPERTY, url);
        map_500.put(HttpConnector.HTTP_STATUS_PROPERTY, "500");

        messageProperties_500 = Collections.unmodifiableMap(map_500);
    }

    // setup 時に呼ばれるメソッド。親クラスのテンプレートメソッドをオーバーライドした。
    @Override
    public void doSetUp() throws Exception {
        super.doSetUp();
        // トランスフォーマのテストをする際は、必ずRequestContextのイベントが設定されてなければならない。
        RequestContext.setEvent(getTestEvent("test"));
    }

    // tear down 時に呼ばれるメソッド。親クラスのテンプレートメソッドをオーバーライドした。
    @Override
    protected void doTearDown() throws Exception {
        super.doTearDown();
        // RequestContext の値をnullに戻し、次のテストメソッドに備える。
        RequestContext.setEvent(null);
    }

    public Transformer getTransformer() throws Exception {
        Transformer trans = createObject(FedletErrorTransformer.class);
        trans.setReturnDataType(DataTypeFactory.create(MuleMessage.class));

        EndpointBuilder builder =
                new EndpointURIEndpointBuilder("test://test", muleContext);
        builder.setEncoding(encoding);
        ImmutableEndpoint endpoint =
                muleContext.getEndpointFactory().getOutboundEndpoint(builder);
        trans.setEndpoint(endpoint);
        return trans;
    }

    public Object getTestData_400() {
        MuleMessage mes =
                new DefaultMuleMessage(TEST_PAYLOAD, messageProperties_400,
                        null, null, muleContext);
        return mes;
    }

    public Object getTestData_500() {
        MuleMessage mes =
                new DefaultMuleMessage(TEST_PAYLOAD, messageProperties_500,
                        null, null, muleContext);
        return mes;
    }

    public Object getResultData() {
        MuleMessage mes =
                new DefaultMuleMessage(null, null, null, null, muleContext);
        return mes;
    }

    @Test(expected = IllegalRequestException.class)
    public void testTransform_IllegalRequestException() throws Exception {
        Transformer trans = this.getTransformer();
        MuleMessage message = (MuleMessage) getTestData_400();
        try {
            trans.transform(message);
            fail("期待したＥｘｃｅｐｔｉｏｎが発生しませんでした。");
        } catch (IllegalRequestException e) {
            String eMessage = e.getMessage();
            assertEquals(RESULT_PAYLOAD_400 + message.toString(), eMessage);
            throw e;
        }
    }

    @Test(expected = FedletException.class)
    public void testTransform_FedletException() throws Exception {
        Transformer trans = this.getTransformer();
        try {
            trans.transform(getTestData_500());
            fail("期待したＥｘｃｅｐｔｉｏｎが発生しませんでした。");
        } catch (FedletException e) {
            String eMessage = e.getMessage();
            System.out.println(eMessage);
            System.out.println(RESULT_PAYLOAD_500);
            assertEquals(RESULT_PAYLOAD_500, eMessage);
            throw e;
        }
    }

}
