/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.common.util;

import static org.junit.Assert.assertSame;
import static org.junit.Assert.assertTrue;
import jp.co.ogis_ri.citk.common.exception.CitkSystemException;

import org.junit.Test;

public class ExceptionUtilTestCase {

    @Test
    public void testConvertRuntimeException() {

        Exception ex = new RuntimeException("test exception!");
        Exception ex2 = ExceptionUtil.convertRuntimeException(ex);
        assertSame(ex, ex2);

    }

    @Test
    public void testConvertRuntimeException_CitkSystemException() {
        Exception ex = new Exception("test exception!");
        Exception ex2 = ExceptionUtil.convertRuntimeException(ex);
        assertTrue("don't convert to CitkSystemException!",
                ex2 instanceof CitkSystemException);
    }

}
