/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.forwarding.transformer;

import jp.co.ogis_ri.citk.common.CitkConstants;
import jp.co.ogis_ri.citk.common.exception.CitkSystemException;

/**
 * 認可結果ごとのForwarding先のエンドポイント管理クラス。
 * 
 * @author ISP Shiraishi
 * 
 */
public class EndpointUrl {
    /**
     * permit時のアウトバウンド・エンドポイント。
     */
    private OutboundEndpoint permit;

    /**
     * deny時のアウトバウンド・エンドポイント。
     */
    private OutboundEndpoint deny;

    /**
     * permit時のアウトバウンド・エンドポイントを取得する。
     * 
     * @return permit時のアウトバウンド・エンドポイント。
     */
    public OutboundEndpoint getPermit() {
        return permit;
    }

    /**
     * permit時のアウトバウンド・エンドポイントを設定する。
     * 
     * @param permit　permit時のアウトバウンド・エンドポイント。
     */
    public void setPermit(OutboundEndpoint permit) {
        this.permit = permit;
    }

    /**
     * deny時のアウトバウンド・エンドポイントを取得する。
     * 
     * @return deny時のアウトバウンド・エンドポイント。
     */
    public OutboundEndpoint getDeny() {
        return deny;
    }

    /**
     * deny時のアウトバウンド・エンドポイントを設定する。
     * 
     * @param deny　deny時のアウトバウンド・エンドポイント。
     */
    public void setDeny(OutboundEndpoint deny) {
        this.deny = deny;
    }

    /**
     * 認可結果ごとのエンドポイントを返却する。
     * 
     * @param authzResult 認可結果。
     * @return　エンドポイント。
     */
    public OutboundEndpoint getOutboundEndpoint(String authzResult) {
        // 判定して返す
        OutboundEndpoint res = null;
        if (authzResult.equals(CitkConstants.AUTHZ_PERMIT)) {
            res = permit;
        } else if (authzResult.equals(CitkConstants.AUTHZ_DENY)
                || authzResult.equals(CitkConstants.AUTHZ_INDETERMINATE)) {
            res = deny;
        } else {
            throw new CitkSystemException("Illigal Authz Result : "
                    + authzResult);
        }
        return res;
    }
}
